/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.google.common.collect.ImmutableMap;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.provision.Host;
import com.yahoo.net.HostName;
import com.yahoo.text.XML;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Hosts {
    public static final Logger log = Logger.getLogger(Hosts.class.getPackage().toString());
    private final ImmutableMap<String, Host> hosts;

    public Hosts(Collection<Host> hosts) {
        this.validateAliases(hosts);
        ImmutableMap.Builder hostsBuilder = new ImmutableMap.Builder();
        for (Host host : hosts) {
            hostsBuilder.put((Object)host.hostname(), (Object)host);
        }
        this.hosts = hostsBuilder.build();
    }

    private void validateAliases(Collection<Host> hosts) {
        HashSet<String> aliases = new HashSet<String>();
        for (Host host : hosts) {
            if (host.aliases().isEmpty()) continue;
            if (host.aliases().isEmpty()) {
                throw new IllegalArgumentException("Host '" + host.hostname() + "' must have at least one <alias> tag.");
            }
            for (String alias : host.aliases()) {
                if (aliases.contains(alias)) {
                    throw new IllegalArgumentException("Alias '" + alias + "' is used by multiple hosts.");
                }
                aliases.add(alias);
            }
        }
    }

    public static Hosts readFrom(Reader hostsFile) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        Document doc = XmlHelper.getDocument(hostsFile);
        for (Element hostE : XML.getChildren((Element)doc.getDocumentElement(), (String)"host")) {
            List<String> hostAliases;
            String name = hostE.getAttribute("name");
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Missing 'name' attribute for host.");
            }
            if ("localhost".equals(name)) {
                name = HostName.getLocalhost();
            }
            if ((hostAliases = Hosts.getHostAliases(hostE.getChildNodes())).isEmpty()) {
                throw new IllegalArgumentException("No host aliases defined for host '" + name + "'");
            }
            hosts.add(new Host(name, hostAliases));
        }
        return new Hosts(hosts);
    }

    public Collection<Host> asCollection() {
        return this.hosts.values();
    }

    public String toString() {
        return "Hosts: " + String.valueOf(this.hosts.keySet());
    }

    private static List<String> getHostAliases(NodeList hostAliases) {
        LinkedList<String> aliases = new LinkedList<String>();
        for (int i = 0; i < hostAliases.getLength(); ++i) {
            Node n = hostAliases.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (!e.getNodeName().equals("alias")) {
                throw new IllegalArgumentException("Unexpected tag: '" + e.getNodeName() + "' at node " + XML.getNodePath((Node)e, (String)" > ") + ", expected 'alias'.");
            }
            String alias = e.getFirstChild().getNodeValue();
            if (alias == null || alias.isEmpty()) {
                throw new IllegalArgumentException("Missing value for the alias tag at node " + XML.getNodePath((Node)e, (String)" > ") + "'.");
            }
            aliases.add(alias);
        }
        return aliases;
    }
}

