/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.logging.FileConnectionLog;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.component.ConnectionLogComponent;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.configserver.option.ConfigOptions;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import org.w3c.dom.Element;

public class ConfigServerContainerModelBuilder
extends ContainerModelBuilder {
    private final ConfigOptions options;

    public ConfigServerContainerModelBuilder(ConfigOptions options) {
        super(true, ContainerModelBuilder.Networking.enable);
        this.options = options;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        ConfigserverCluster cluster = new ConfigserverCluster(modelContext.getParentProducer(), "configserver", this.options, modelContext.featureFlags());
        super.doBuild(model, spec, modelContext.withParent(cluster));
        cluster.setContainerCluster(model.getCluster());
    }

    @Override
    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        super.addStatusHandlers(cluster, this.isHosted());
    }

    @Override
    protected void addAccessLogs(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        if (this.isHosted()) {
            cluster.addAccessLog("logs/vespa/configserver/access-json.log.%Y%m%d%H%M%S", "access-json.log");
            cluster.addComponent(new ConnectionLogComponent(cluster, FileConnectionLog.class, "configserver"));
        } else {
            super.addAccessLogs(deployState, cluster, spec);
        }
    }

    @Override
    protected void addModelEvaluationRuntime(ApplicationContainerCluster cluster) {
    }

    private boolean isHosted() {
        return this.options.hostedVespa().orElse(Boolean.FALSE);
    }
}

