/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.container.QrConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import java.util.Set;
import java.util.stream.Collectors;

public class ContainerRestartValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        boolean nodesUnchanged = context.previousModel().allocatedHosts().equals((Object)context.model().allocatedHosts());
        boolean contentUnchanged = this.contentHostsOf(context.previousModel()).equals(this.contentHostsOf(context.model()));
        for (ContainerCluster containerCluster : context.model().getContainerClusters().values()) {
            containerCluster.getContainers().stream().filter(container -> ContainerRestartValidator.isExistingContainer(container, context.previousModel())).filter(container -> ContainerRestartValidator.shouldContainerRestartOnDeploy(container, context.model())).map(container -> ContainerRestartValidator.createConfigChangeAction(cluster.id(), container, context.model(), nodesUnchanged, contentUnchanged)).forEach(context::require);
        }
    }

    private Set<HostSpec> contentHostsOf(VespaModel model) {
        return model.allocatedHosts().getHosts().stream().filter(spec -> spec.membership().map(membership -> membership.cluster().type().isContent()).orElse(false)).collect(Collectors.toUnmodifiableSet());
    }

    private static ConfigChangeAction createConfigChangeAction(ClusterSpec.Id id, Container container, VespaModel model, boolean nodesUnchanged, boolean contentUnchanged) {
        boolean ignoreOnRedeploy = switch (model.getConfig(QrConfig.class, container.getConfigId()).restartOnInternalRedeploy()) {
            default -> throw new IncompatibleClassChangeError();
            case QrConfig.RestartOnInternalRedeploy.Enum.never -> true;
            case QrConfig.RestartOnInternalRedeploy.Enum.content_changes -> contentUnchanged;
            case QrConfig.RestartOnInternalRedeploy.Enum.node_changes -> nodesUnchanged;
            case QrConfig.RestartOnInternalRedeploy.Enum.always -> false;
        };
        return new VespaRestartAction(id, ContainerRestartValidator.createMessage(container), container.getServiceInfo(), ignoreOnRedeploy);
    }

    private static String createMessage(Container container) {
        return String.format("Container '%s' is configured to always restart on deploy.", container.getConfigId());
    }

    private static boolean shouldContainerRestartOnDeploy(Container container, VespaModel nextModel) {
        QrConfig config = nextModel.getConfig(QrConfig.class, container.getConfigId());
        return config.restartOnDeploy();
    }

    private static boolean isExistingContainer(Container container, VespaModel currentModel) {
        return currentModel.getService(container.getConfigId()).isPresent();
    }
}

