/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import java.util.ArrayList;
import java.util.List;

public class SearchField
extends Field {
    private boolean attribute = false;
    private boolean indexed = false;
    private List<Feature> featureList = new ArrayList<Feature>();

    public SearchField(Field field, boolean indexed, boolean attribute) {
        this(field, indexed, attribute, null);
    }

    public SearchField(Field field, boolean indexed, boolean attribute, List<Feature> features) {
        super(field.getName(), field);
        this.attribute = attribute;
        this.indexed = indexed;
        if (features != null) {
            this.featureList.addAll(features);
        }
        this.validate();
    }

    private void validate() {
        if (this.attribute || !this.indexed) {
            return;
        }
        DataType fieldType = this.getDataType();
        PrimitiveDataType primiType = fieldType.getPrimitiveType();
        if (DataType.STRING.equals((Object)primiType) || DataType.URI.equals((Object)primiType)) {
            return;
        }
        throw new IllegalArgumentException("Expected type " + DataType.STRING.getName() + " for indexed field '" + this.getName() + "', got " + fieldType.getName() + ".");
    }

    public SearchField setIndexed() {
        this.indexed = true;
        this.validate();
        return this;
    }

    public SearchField setAttribute() {
        this.attribute = true;
        this.validate();
        return this;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public SearchField addFeature(Feature feature) {
        this.featureList.add(feature);
        this.validate();
        return this;
    }

    public static enum Feature {
        WEIGHT_IN_ATTRIBUTE_POSTINGS("WeightInAttributePosting"),
        WORDPOS_IN_POSTINGS("WordPosInPosting"),
        FILTER_ONLY("FilterOnly");

        private String name;

        private Feature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

