/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains.search;

import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.vespa.model.builder.xml.dom.chains.search.TimeParser;
import org.w3c.dom.Element;

public class FederationOptionsBuilder {
    public static final String federationOptionsElement = "federationoptions";
    private final FederationOptions federationOptions;

    FederationOptionsBuilder(Element spec) {
        this.federationOptions = new FederationOptions().setUseByDefault(this.readUseByDefault(spec)).setOptional(this.readOptional(spec)).setTimeoutInMilliseconds(this.readTimeout(spec)).setRequestTimeoutInMilliseconds(this.readRequestTimeout(spec));
    }

    private Integer readTimeout(Element spec) {
        String timeout = spec.getAttribute("timeout");
        return timeout.isEmpty() ? null : Integer.valueOf(TimeParser.asMilliSeconds(timeout));
    }

    private Integer readRequestTimeout(Element spec) {
        String requestTimeout = spec.getAttribute("requestTimeout");
        return requestTimeout.isEmpty() ? null : Integer.valueOf(TimeParser.asMilliSeconds(requestTimeout));
    }

    private Boolean readOptional(Element spec) {
        String optional = spec.getAttribute("optional");
        return optional.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(optional));
    }

    private Boolean readUseByDefault(Element spec) {
        String useByDefault = spec.getAttribute("default");
        return useByDefault.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(useByDefault));
    }

    FederationOptions build() {
        return this.federationOptions;
    }
}

