/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class ContentClusterRemovalValidator
implements ChangeValidator {
    @Override
    public void validate(Validation.ChangeContext context) {
        for (String currentClusterId : context.previousModel().getContentClusters().keySet()) {
            ContentCluster nextCluster = context.model().getContentClusters().get(currentClusterId);
            if (nextCluster != null) continue;
            context.invalid(ValidationId.contentClusterRemoval, "Content cluster '" + currentClusterId + "' is removed. This will cause loss of all data in this cluster");
            for (ApplicationContainerCluster cluster : context.model().getContainerClusters().values()) {
                context.require(new VespaRestartAction(cluster.id(), "Content cluster '" + currentClusterId + "' has been removed", cluster.getContainers().stream().map(AbstractService::getServiceInfo).toList()));
            }
        }
    }
}

