/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.config.subscription.ConfigInstanceUtil;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.ConfigTransformer;
import com.yahoo.vespa.config.GenericConfig;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AnyConfigProducer
implements ConfigProducer,
ConfigInstance.Producer,
Serializable {
    public static final Logger log = Logger.getLogger(AnyConfigProducer.class.getPackage().toString());
    private final String subId;
    private String configId = null;
    private TreeConfigProducer parent = null;
    private UserConfigRepo userConfigs = new UserConfigRepo();

    protected static boolean stateIsHosted(DeployState deployState) {
        return deployState != null && deployState.isHosted();
    }

    public AnyConfigProducer(TreeConfigProducer parent, String subId) {
        this(subId);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    protected void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    protected final void setParent(TreeConfigProducer parent) {
        this.parent = parent;
        this.computeConfigId();
    }

    public final String getSubId() {
        return this.subId;
    }

    public AnyConfigProducer(String subId) {
        if (subId.indexOf(47) != -1) {
            throw new IllegalArgumentException("A subId might not contain '/' : '" + subId + "'");
        }
        this.subId = subId;
    }

    public void setUserConfigs(UserConfigRepo repo) {
        this.userConfigs = repo;
    }

    @Override
    public UserConfigRepo getUserConfigs() {
        return this.userConfigs;
    }

    @Override
    public final String getConfigId() {
        if (this.configId == null) {
            throw new IllegalStateException("The system topology must be frozen first.");
        }
        return this.configId;
    }

    protected final String currentConfigId() {
        return this.configId;
    }

    protected void addConfigId(String id) {
        if (id == null) {
            throw new NullPointerException("Config ID cannot be null.");
        }
        this.getRoot().addDescendant(id, this);
        if (!this.isVespa() && this.getVespa() != null) {
            this.getVespa().addDescendant(this);
        }
    }

    @Override
    public final boolean cascadeConfig(ConfigInstance.Builder builder) {
        boolean found = false;
        if (this.parent != null) {
            found = this.parent.cascadeConfig(builder);
        }
        boolean foundHere = builder.dispatchGetConfig((ConfigInstance.Producer)this);
        log.log(Level.FINE, () -> "cascadeconfig in " + this + ", getting config " + builder.getClass().getDeclaringClass().getName() + " for config id '" + this.configId + "' found here=" + foundHere);
        found = found || foundHere;
        return found;
    }

    @Override
    public final boolean addUserConfig(ConfigInstance.Builder builder) {
        boolean didApply = false;
        if (this.parent != null) {
            didApply = this.parent.addUserConfig(builder);
        }
        log.log(Level.FINEST, () -> "User configs is: " + this.userConfigs.toString());
        ConfigDefinitionKey key = new ConfigDefinitionKey(builder.getDefName(), builder.getDefNamespace());
        if (this.userConfigs.get(key) != null) {
            log.log(Level.FINEST, () -> "Apply in " + this.configId);
            this.applyUserConfig(builder, this.userConfigs.get(key));
            didApply = true;
        }
        return didApply;
    }

    private void applyUserConfig(ConfigInstance.Builder builder, ConfigPayloadBuilder payloadBuilder) {
        ConfigInstance.Builder override = builder instanceof GenericConfig.GenericConfigBuilder ? this.getGenericConfigBuilderOverride((GenericConfig.GenericConfigBuilder)builder, payloadBuilder) : this.getConfigInstanceBuilderOverride(builder, ConfigPayload.fromBuilder((ConfigPayloadBuilder)payloadBuilder));
        ConfigInstanceUtil.setValues((ConfigBuilder)builder, (ConfigBuilder)override);
    }

    private ConfigInstance.Builder getGenericConfigBuilderOverride(GenericConfig.GenericConfigBuilder builder, ConfigPayloadBuilder payloadBuilder) {
        ConfigDefinitionKey key = new ConfigDefinitionKey(builder.getDefName(), builder.getDefNamespace());
        return new GenericConfig.GenericConfigBuilder(key, payloadBuilder);
    }

    private ConfigInstance.Builder getConfigInstanceBuilderOverride(ConfigInstance.Builder builder, ConfigPayload payload) {
        try {
            ConfigTransformer transformer = new ConfigTransformer(builder.getClass().getEnclosingClass());
            return transformer.toConfigBuilder(payload);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error applying override to builder", e);
        }
    }

    @Override
    public HostSystem hostSystem() {
        return this.getRoot().hostSystem();
    }

    public AbstractConfigProducerRoot getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    private ApplicationConfigProducerRoot getVespa() {
        if (this.isRoot()) {
            return null;
        }
        if (this.isVespa()) {
            return (ApplicationConfigProducerRoot)this;
        }
        return this.getParent().getVespa();
    }

    private boolean isRoot() {
        return this.parent == null;
    }

    private boolean isVespa() {
        return this instanceof ApplicationConfigProducerRoot && this.getParent().isRoot();
    }

    public AnyConfigProducer getParent() {
        return this.parent;
    }

    void setupConfigId(String parentConfigId) {
        if (this instanceof AbstractConfigProducerRoot) {
            this.configId = "";
        } else {
            this.configId = parentConfigId + this.subId;
            this.addConfigId(this.configId);
        }
        this.computeConfigId();
    }

    private void computeConfigId() {
        if (this.parent == null) {
            return;
        }
        String parentConfigId = this.parent.getConfigIdPrefix();
        if (parentConfigId == null) {
            return;
        }
        String oldConfigId = this.configId;
        this.configId = this instanceof AbstractConfigProducerRoot ? "" : parentConfigId + this.subId;
        if (oldConfigId == null) {
            return;
        }
        if (!this.configId.equals(oldConfigId)) {
            throw new IllegalArgumentException("configId cannot change " + oldConfigId + " -> " + this.configId + " (invalid topology change)");
        }
    }

    protected static ClassLoader findInheritedClassLoader(Class clazz, String producerName) {
        Class<?>[] interfazes;
        for (Class<?> interfaze : interfazes = clazz.getInterfaces()) {
            if (!producerName.equals(interfaze.getName())) continue;
            return interfaze.getClassLoader();
        }
        if (clazz.getSuperclass() == null) {
            return null;
        }
        return AnyConfigProducer.findInheritedClassLoader(clazz.getSuperclass(), producerName);
    }

    protected ClassLoader getConfigClassLoader(String producerName) {
        return AnyConfigProducer.findInheritedClassLoader(this.getClass(), producerName);
    }

    public void mergeUserConfigs(UserConfigRepo newRepo) {
        this.userConfigs.merge(newRepo);
    }

    protected Monitoring getMonitoringService() {
        Admin admin;
        AbstractConfigProducerRoot root = this.getRoot();
        Admin admin2 = admin = root == null ? null : root.getAdmin();
        if (admin == null) {
            return null;
        }
        if (admin.getMonitoring() != null) {
            return admin.getMonitoring();
        }
        return null;
    }

    void aggregateDescendantServices() {
    }

    @Override
    public List<Service> getDescendantServices() {
        return List.of();
    }

    <J extends AnyConfigProducer> List<J> getChildrenByTypeRecursive(Class<J> type) {
        return List.of();
    }

    void freeze() {
    }

    @Override
    public void validate() throws Exception {
    }
}

