/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.documentmodel.NewDocumentType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GlobalDistributionValidator {
    public void validate(Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments) {
        GlobalDistributionValidator.verifyReferredDocumentsArePresent(documentDefinitions);
        GlobalDistributionValidator.verifyReferredDocumentsAreGlobal(documentDefinitions, globallyDistributedDocuments);
    }

    private static void verifyReferredDocumentsArePresent(Map<String, NewDocumentType> documentDefinitions) {
        Set unknowDocuments = GlobalDistributionValidator.getReferencedDocuments(documentDefinitions).filter(name -> !documentDefinitions.containsKey(name.toString())).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        if (!unknowDocuments.isEmpty()) {
            throw new IllegalArgumentException("The following document types are referenced from other documents, but are not listed in services.xml: " + GlobalDistributionValidator.asPrintableString(unknowDocuments.stream()));
        }
    }

    private static void verifyReferredDocumentsAreGlobal(Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments) {
        Set nonGlobalReferencedDocuments = GlobalDistributionValidator.getReferencedDocuments(documentDefinitions).map(name -> (NewDocumentType)documentDefinitions.get(name.toString())).filter(documentType -> !globallyDistributedDocuments.contains(documentType)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        if (!nonGlobalReferencedDocuments.isEmpty()) {
            throw new IllegalArgumentException("The following document types are referenced from other documents, but are not globally distributed: " + GlobalDistributionValidator.asPrintableString(GlobalDistributionValidator.toDocumentNameStream(nonGlobalReferencedDocuments)));
        }
    }

    private static Stream<NewDocumentType.Name> getReferencedDocuments(Map<String, NewDocumentType> documentDefinitions) {
        return documentDefinitions.values().stream().map(NewDocumentType::getDocumentReferences).flatMap(Collection::stream);
    }

    private static Stream<NewDocumentType.Name> toDocumentNameStream(Set<NewDocumentType> globallyDistributedDocuments) {
        return globallyDistributedDocuments.stream().map(NewDocumentType::getFullName);
    }

    private static String asPrintableString(Stream<NewDocumentType.Name> documentTypes) {
        return documentTypes.map(name -> "'" + name + "'").collect(Collectors.joining(", "));
    }
}

