/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.FileReference;
import com.yahoo.config.ModelReference;
import com.yahoo.config.UrlReference;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.text.XML;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ModelIdResolver {
    public static final String HF_TOKENIZER = "huggingface-tokenizer";
    public static final String ONNX_MODEL = "onnx-model";
    public static final String BERT_VOCAB = "bert-vocabulary";
    public static final String SIGNIFICANCE_MODEL = "significance-model";
    public static final String GGUF_MODEL = "gguf-model";
    private static final Map<String, ProvidedModel> providedModels = ModelIdResolver.setupProvidedModels();

    private static Map<String, ProvidedModel> setupProvidedModels() {
        HashMap<String, ProvidedModel> m = new HashMap<String, ProvidedModel>();
        ModelIdResolver.register(m, "minilm-l6-v2", "https://data.vespa.oath.cloud/onnx_models/sentence_all_MiniLM_L6_v2.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "mpnet-base-v2", "https://data.vespa.oath.cloud/onnx_models/sentence-all-mpnet-base-v2.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "bert-base-uncased", "https://data.vespa.oath.cloud/onnx_models/bert-base-uncased-vocab.txt", Set.of(BERT_VOCAB));
        ModelIdResolver.register(m, "flan-t5-vocab", "https://data.vespa.oath.cloud/onnx_models/flan-t5-spiece.model", Set.of());
        ModelIdResolver.register(m, "flan-t5-small-encoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-small-encoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "flan-t5-small-decoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-small-decoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "flan-t5-base-encoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-base-encoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "flan-t5-base-decoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-base-decoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "flan-t5-large-encoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-large-encoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "flan-t5-large-decoder", "https://data.vespa.oath.cloud/onnx_models/flan-t5-large-decoder-model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "multilingual-e5-base", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-base/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "multilingual-e5-base-vocab", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-base/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "multilingual-e5-small", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-small/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "multilingual-e5-small-vocab", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-small/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "multilingual-e5-small-cpu-friendly", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-small-cpu-friendly/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "multilingual-e5-small-cpu-friendly-vocab", "https://data.vespa.oath.cloud/onnx_models/multilingual-e5-small-cpu-friendly/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "e5-small-v2", "https://data.vespa.oath.cloud/onnx_models/e5-small-v2/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "e5-small-v2-vocab", "https://data.vespa.oath.cloud/onnx_models/e5-small-v2/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "e5-small-v2-cpu-friendly", "https://data.vespa.oath.cloud/onnx_models/e5-small-v2-cpu-friendly/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "e5-small-v2-cpu-friendly-vocab", "https://data.vespa.oath.cloud/onnx_models/e5-small-v2-cpu-friendly/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "e5-base-v2", "https://data.vespa.oath.cloud/onnx_models/e5-base-v2/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "e5-base-v2-vocab", "https://data.vespa.oath.cloud/onnx_models/e5-base-v2/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "e5-large-v2", "https://data.vespa.oath.cloud/onnx_models/e5-large-v2/model.onnx", Set.of(ONNX_MODEL));
        ModelIdResolver.register(m, "e5-large-v2-vocab", "https://data.vespa.oath.cloud/onnx_models/e5-large-v2/tokenizer.json", Set.of(HF_TOKENIZER));
        ModelIdResolver.register(m, "mistral-7b", "https://data.vespa.oath.cloud/gguf_models/mistral-7b-instruct-v0.1.Q6_K.gguf", Set.of(GGUF_MODEL));
        ModelIdResolver.register(m, "mistral-7b-q8", "https://data.vespa.oath.cloud/gguf_models/mistral-7b-instruct-v0.1.Q8_0.gguf", Set.of(GGUF_MODEL));
        return Map.copyOf(m);
    }

    private static void register(Map<String, ProvidedModel> models, String modelId, String uri, Set<String> tags) {
        models.put(modelId, new ProvidedModel(modelId, URI.create(uri), tags));
    }

    public static void resolveModelIds(Element component, boolean hosted) {
        for (Element config : XML.getChildren((Element)component, (String)"config")) {
            for (Element value : XML.getChildren((Element)config)) {
                ModelIdResolver.transformModelValue(value, hosted);
            }
        }
    }

    private static void transformModelValue(Element value, boolean hosted) {
        if (!value.hasAttribute("model-id")) {
            return;
        }
        if (hosted) {
            value.setAttribute("url", ModelIdResolver.modelIdToUrl(value.getTagName(), value.getAttribute("model-id"), Set.of()));
            value.removeAttribute("path");
        } else if (!value.hasAttribute("url") && !value.hasAttribute("path")) {
            throw ModelIdResolver.onlyModelIdInHostedException(value.getTagName());
        }
    }

    public static ModelReference resolveToModelReference(String paramName, Optional<String> id, Optional<String> url, Optional<String> path, Set<String> requiredTags, DeployState state) {
        if (id.isEmpty()) {
            return ModelIdResolver.createModelReference(Optional.empty(), url, path, state);
        }
        if (state.isHosted()) {
            return ModelIdResolver.createModelReference(id, Optional.of(ModelIdResolver.modelIdToUrl(paramName, id.get(), requiredTags)), Optional.empty(), state);
        }
        if (url.isEmpty() && path.isEmpty()) {
            throw ModelIdResolver.onlyModelIdInHostedException(paramName);
        }
        return ModelIdResolver.createModelReference(id, url, path, state);
    }

    private static ModelReference createModelReference(Optional<String> id, Optional<String> url, Optional<String> path, DeployState state) {
        Optional<FileReference> fileRef = path.map(p -> state.getFileRegistry().addFile(p));
        return ModelReference.unresolved(id, url.map(UrlReference::valueOf), fileRef);
    }

    private static IllegalArgumentException onlyModelIdInHostedException(String paramName) {
        return new IllegalArgumentException(paramName + " is configured with only a 'model-id'. Add a 'path' or 'url' to deploy this outside Vespa Cloud");
    }

    private static String modelIdToUrl(String valueName, String modelId, Set<String> requiredTags) {
        if (!providedModels.containsKey(modelId)) {
            throw new IllegalArgumentException("Unknown model id '" + modelId + "' on '" + valueName + "'. Available models are [" + providedModels.keySet().stream().sorted().collect(Collectors.joining(", ")) + "]");
        }
        ProvidedModel providedModel = providedModels.get(modelId);
        if (!providedModel.tags().containsAll(requiredTags)) {
            throw new IllegalArgumentException("Model '%s' on '%s' has tags %s but are missing required tags %s".formatted(modelId, valueName, providedModel.tags(), requiredTags));
        }
        return providedModel.uri().toString();
    }

    private record ProvidedModel(String modelId, URI uri, Set<String> tags) {
        ProvidedModel {
            tags = Set.copyOf(tags);
        }
    }
}

