/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.container.logging.JSONAccessLog;
import com.yahoo.container.logging.VespaAccessLog;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.Objects;
import java.util.Optional;

public final class AccessLogComponent
extends SimpleComponent
implements AccessLogConfig.Producer {
    private final String fileNamePattern;
    private final String rotationInterval;
    private final Boolean compression;
    private final boolean isHostedVespa;
    private final String symlinkName;
    private final CompressionType compressionType;
    private final int queueSize;
    private final Integer bufferSize;

    public AccessLogComponent(ContainerCluster<?> cluster, AccessLogType logType, String compressionType, Optional<String> clusterName, boolean isHostedVespa) {
        this(logType, compressionType, String.format("logs/vespa/access/%s.%s", AccessLogComponent.capitalize(AccessLogComponent.logTypeAndClusterName(logType, clusterName)), "%Y%m%d%H%M%S"), null, null, isHostedVespa, AccessLogComponent.capitalize(AccessLogComponent.logTypeAndClusterName(logType, clusterName)), -1, cluster instanceof ApplicationContainerCluster ? Integer.valueOf(0x400000) : null);
    }

    public AccessLogComponent(AccessLogType logType, String compressionType, String fileNamePattern, String rotationInterval, Boolean compressOnRotation, boolean isHostedVespa, String symlinkName, Integer queueSize, Integer bufferSize) {
        super(new ComponentModel(AccessLogComponent.accessLogClass(logType), null, null, null));
        this.fileNamePattern = Objects.requireNonNull(fileNamePattern, "File name pattern required when configuring access log");
        this.rotationInterval = rotationInterval;
        this.compression = compressOnRotation;
        this.isHostedVespa = isHostedVespa;
        this.symlinkName = symlinkName;
        this.compressionType = "zstd".equals(compressionType) ? CompressionType.ZSTD : CompressionType.GZIP;
        this.queueSize = queueSize == null ? 256 : queueSize;
        this.bufferSize = bufferSize;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String logTypeAndClusterName(AccessLogType logType, Optional<String> clusterName) {
        return clusterName.isEmpty() ? logType.name() : logType.name() + "." + clusterName.get();
    }

    private static String accessLogClass(AccessLogType logType) {
        return switch (logType) {
            default -> throw new IncompatibleClassChangeError();
            case AccessLogType.queryAccessLog -> VespaAccessLog.class.getName();
            case AccessLogType.jsonAccessLog -> JSONAccessLog.class.getName();
        };
    }

    public void getConfig(AccessLogConfig.Builder builder) {
        builder.fileHandler(this.fileHandlerConfig());
    }

    private AccessLogConfig.FileHandler.Builder fileHandlerConfig() {
        AccessLogConfig.FileHandler.Builder builder = new AccessLogConfig.FileHandler.Builder();
        if (this.fileNamePattern != null) {
            builder.pattern(this.fileNamePattern);
        }
        if (this.rotationInterval != null) {
            builder.rotation(this.rotationInterval);
        }
        if (this.symlinkName != null) {
            builder.symlink(this.symlinkName);
        }
        if (this.compression != null) {
            builder.compressOnRotation(this.compression.booleanValue());
        } else if (this.isHostedVespa) {
            builder.compressOnRotation(true);
        }
        builder.queueSize(this.queueSize);
        if (this.bufferSize != null) {
            builder.bufferSize(this.bufferSize.intValue());
        }
        return switch (this.compressionType) {
            default -> throw new IncompatibleClassChangeError();
            case CompressionType.GZIP -> builder.compressionFormat(AccessLogConfig.FileHandler.CompressionFormat.Enum.GZIP);
            case CompressionType.ZSTD -> builder.compressionFormat(AccessLogConfig.FileHandler.CompressionFormat.Enum.ZSTD);
        };
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public static enum AccessLogType {
        queryAccessLog,
        jsonAccessLog;

    }

    public static enum CompressionType {
        GZIP,
        ZSTD;

    }
}

