/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.cloud.config.ApplicationIdConfig;
import com.yahoo.cloud.config.ClusterListConfig;
import com.yahoo.cloud.config.ModelConfig;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.cloud.config.log.LogdConfig;
import com.yahoo.component.Version;
import com.yahoo.config.model.CommonConfigsProducer;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.config.DocumenttypesConfig;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolPoliciesConfig;
import com.yahoo.documentapi.messagebus.protocol.DocumentrouteselectorpolicyConfig;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.vespa.config.content.AllClustersBucketSpacesConfig;
import com.yahoo.vespa.config.content.DistributionConfig;
import com.yahoo.vespa.configmodel.producers.DocumentManager;
import com.yahoo.vespa.configmodel.producers.DocumentTypes;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.routing.Routing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApplicationConfigProducerRoot
extends TreeConfigProducer<AnyConfigProducer>
implements CommonConfigsProducer {
    private final DocumentModel documentModel;
    private Routing routing = null;
    Map<String, ConfigProducer> id2producer = new LinkedHashMap<String, ConfigProducer>();
    private Admin admin = null;
    private HostSystem hostSystem = null;
    private final Version vespaVersion;
    private final ApplicationId applicationId;
    private boolean useV8GeoPositions = false;

    public ApplicationConfigProducerRoot(TreeConfigProducer<AnyConfigProducer> parent, String name, DocumentModel documentModel, Version vespaVersion, ApplicationId applicationId) {
        super(parent, name);
        this.documentModel = documentModel;
        this.vespaVersion = vespaVersion;
        this.applicationId = applicationId;
    }

    public void useFeatureFlags(ModelContext.FeatureFlags featureFlags) {
        this.useV8GeoPositions = featureFlags.useV8GeoPositions();
    }

    public Set<String> getConfigIds() {
        return Collections.unmodifiableSet(this.id2producer.keySet());
    }

    public ConfigProducer getConfigProducer(String configId) {
        return this.id2producer.get(configId);
    }

    public void addDescendant(AnyConfigProducer descendant) {
        this.id2producer.put(descendant.getConfigId(), descendant);
    }

    public void prepare(ConfigModelRepo plugins) {
        if (this.routing != null) {
            this.routing.deriveCommonSettings(plugins);
        }
    }

    public void setupAdmin(Admin admin) {
        this.admin = admin;
    }

    public void setupRouting(DeployState deployState, VespaModel vespaModel, ConfigModelRepo configModels) {
        if (this.admin != null) {
            Routing routing = configModels.getRouting();
            if (routing == null) {
                routing = new Routing(ConfigModelContext.create(deployState, vespaModel, configModels, this, "routing"));
                configModels.add(routing);
            }
            this.routing = routing;
        }
    }

    public void getConfig(DocumentmanagerConfig.Builder builder) {
        new DocumentManager().useV8GeoPositions(this.useV8GeoPositions).produce(this.documentModel, builder);
    }

    public void getConfig(DocumenttypesConfig.Builder builder) {
        new DocumentTypes().useV8GeoPositions(this.useV8GeoPositions).produce(this.documentModel, builder);
    }

    public void getConfig(DocumentrouteselectorpolicyConfig.Builder builder) {
        if (this.routing != null) {
            this.routing.getConfig(builder);
        }
    }

    public void getConfig(DocumentProtocolPoliciesConfig.Builder builder) {
        if (this.routing != null) {
            this.routing.getConfig(builder);
        }
    }

    public void getConfig(MessagebusConfig.Builder builder) {
        if (this.routing != null) {
            this.routing.getConfig(builder);
        }
    }

    public void getConfig(LogdConfig.Builder builder) {
        if (this.admin != null) {
            this.admin.getConfig(builder);
        }
    }

    public void getConfig(SlobroksConfig.Builder builder) {
        if (this.admin != null) {
            this.admin.getConfig(builder);
        }
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        if (this.admin != null) {
            this.admin.getConfig(builder);
        }
    }

    public void getConfig(ClusterListConfig.Builder builder) {
        VespaModel model = (VespaModel)this.getRoot();
        for (ContentCluster cluster : model.getContentClusters().values()) {
            ClusterListConfig.Storage.Builder storage = new ClusterListConfig.Storage.Builder();
            storage.name(cluster.getName());
            storage.configid(cluster.getConfigId());
            builder.storage(storage);
        }
    }

    public void getConfig(DistributionConfig.Builder builder) {
        for (ContentCluster cluster : ((VespaModel)this.getRoot()).getContentClusters().values()) {
            cluster.getConfig(builder);
        }
    }

    public void getConfig(AllClustersBucketSpacesConfig.Builder builder) {
        VespaModel model = (VespaModel)this.getRoot();
        for (ContentCluster cluster : model.getContentClusters().values()) {
            builder.cluster(cluster.getName(), cluster.clusterBucketSpaceConfigBuilder());
        }
    }

    public void getConfig(ModelConfig.Builder builder) {
        builder.vespaVersion(this.vespaVersion.toFullString());
        for (HostResource modelHost : this.hostSystem().getHosts()) {
            builder.hosts(new ModelConfig.Hosts.Builder().name(modelHost.getHostname()).services(this.getServices(modelHost)));
        }
    }

    public List<StatePortInfo> getStatePorts() {
        ArrayList<StatePortInfo> result = new ArrayList<StatePortInfo>();
        for (HostResource modelHost : this.hostSystem().getHosts()) {
            String hostName = modelHost.getHostname();
            for (Service modelService : modelHost.getServices()) {
                String serviceName = modelService.getServiceName();
                String serviceType = modelService.getServiceType();
                PortsMeta portsMeta = modelService.getPortsMeta();
                for (int i = 0; i < portsMeta.getNumPorts(); ++i) {
                    int portNumber = modelService.getRelativePort(i);
                    boolean hasState = false;
                    boolean isHttp = false;
                    for (String tag : portsMeta.getTagsAt(i)) {
                        if (tag.equals("state")) {
                            hasState = true;
                        }
                        if (!tag.equals("http")) continue;
                        isHttp = true;
                    }
                    if (!hasState || !isHttp) continue;
                    result.add(new StatePortInfo(hostName, portNumber, serviceName, serviceType));
                }
            }
        }
        return result;
    }

    private List<ModelConfig.Hosts.Services.Builder> getServices(HostResource modelHost) {
        ArrayList<ModelConfig.Hosts.Services.Builder> ret = new ArrayList<ModelConfig.Hosts.Services.Builder>();
        for (Service modelService : modelHost.getServices()) {
            ret.add(new ModelConfig.Hosts.Services.Builder().name(modelService.getServiceName()).type(modelService.getServiceType()).configid(modelService.getConfigId()).clustertype(modelService.getServicePropertyString("clustertype", "")).clustername(modelService.getServicePropertyString("clustername", "")).index(Integer.parseInt(modelService.getServicePropertyString("index", "999999"))).ports(this.getPorts(modelService)));
        }
        return ret;
    }

    private List<ModelConfig.Hosts.Services.Ports.Builder> getPorts(Service modelService) {
        ArrayList<ModelConfig.Hosts.Services.Ports.Builder> ret = new ArrayList<ModelConfig.Hosts.Services.Ports.Builder>();
        PortsMeta portsMeta = modelService.getPortsMeta();
        for (int i = 0; i < portsMeta.getNumPorts(); ++i) {
            ret.add(new ModelConfig.Hosts.Services.Ports.Builder().number(modelService.getRelativePort(i)).tags(ApplicationConfigProducerRoot.getPortTags(portsMeta, i)));
        }
        return ret;
    }

    public static String getPortTags(PortsMeta portsMeta, int portNumber) {
        StringBuilder sb = new StringBuilder();
        boolean firstTag = true;
        for (String s : portsMeta.getTagsAt(portNumber)) {
            if (!firstTag) {
                sb.append(" ");
            } else {
                firstTag = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void setHostSystem(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    @Override
    public HostSystem hostSystem() {
        return this.hostSystem;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public void getConfig(ApplicationIdConfig.Builder builder) {
        builder.tenant(this.applicationId.tenant().value());
        builder.application(this.applicationId.application().value());
        builder.instance(this.applicationId.instance().value());
    }

    public record StatePortInfo(String hostName, int portNumber, String serviceName, String serviceType) {
    }
}

