/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.model.Host;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileDistributor {
    private final FileRegistry fileRegistry;
    private final List<ConfigServerSpec> configServerSpecs;
    private final boolean isHosted;
    private final Map<FileReference, Set<Host>> filesToHosts = new LinkedHashMap<FileReference, Set<Host>>();

    public FileDistributor(FileRegistry fileRegistry, List<ConfigServerSpec> configServerSpecs, boolean isHosted) {
        this.fileRegistry = fileRegistry;
        this.configServerSpecs = configServerSpecs;
        this.isHosted = isHosted;
    }

    public FileReference sendFileToHost(String relativePath, Host host) {
        return this.addFileReference(this.fileRegistry.addFile(relativePath), host);
    }

    public FileReference sendUriToHost(String uri, Host host) {
        return this.addFileReference(this.fileRegistry.addUri(uri), host);
    }

    public FileReference sendBlobToHost(ByteBuffer blob, Host host) {
        return this.addFileReference(this.fileRegistry.addBlob(blob), host);
    }

    private FileReference addFileReference(FileReference reference, Host host) {
        this.filesToHosts.computeIfAbsent(reference, k -> new HashSet()).add(host);
        return reference;
    }

    public Set<FileReference> filesToSendToHost(Host host) {
        HashSet<FileReference> files = new HashSet<FileReference>();
        for (Map.Entry<FileReference, Set<Host>> e : this.filesToHosts.entrySet()) {
            if (!e.getValue().contains(host)) continue;
            files.add(e.getKey());
        }
        return files;
    }

    public Set<Host> getTargetHosts() {
        HashSet<Host> hosts = new HashSet<Host>();
        for (Set<Host> hostSubset : this.filesToHosts.values()) {
            hosts.addAll(hostSubset);
        }
        return hosts;
    }

    public String fileSourceHost() {
        return this.fileRegistry.fileSourceHost();
    }

    public Set<FileReference> allFilesToSend() {
        return Set.copyOf(this.filesToHosts.keySet());
    }

    public void sendDeployedFiles(FileDistribution dbHandler) {
        String fileSourceHost = this.fileSourceHost();
        this.configServerSpecs.stream().filter(spec -> !spec.getHostName().equals(fileSourceHost)).forEach(spec -> dbHandler.startDownload(spec.getHostName(), spec.getConfigServerPort(), this.allFilesToSend()));
        if (this.isHosted) {
            return;
        }
        this.getTargetHosts().stream().filter(host -> !host.getHostname().equals(fileSourceHost)).forEach(host -> dbHandler.startDownload(host.getHostname(), 19090, this.filesToSendToHost((Host)host)));
    }
}

