/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OnnxModels {
    private final Map<String, OnnxModel> models = new HashMap<String, OnnxModel>();

    public void add(OnnxModel model) {
        model.validate();
        String name = model.getName();
        this.models.put(name, model);
    }

    public void add(Map<String, OnnxModel> models) {
        models.values().forEach(this::add);
    }

    public OnnxModel get(String name) {
        return this.models.get(name);
    }

    public boolean has(String name) {
        return this.models.containsKey(name);
    }

    public Map<String, OnnxModel> asMap() {
        return Collections.unmodifiableMap(this.models);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.models.values().forEach(model -> model.sendTo(services));
    }
}

