/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.documentmodel.DataTypeCollection;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.TemporaryImportedFields;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.searchdefinition.document.annotation.TemporaryAnnotationReferenceDataType;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SearchDef;
import com.yahoo.vespa.documentmodel.SearchField;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DocumentModelBuilder {
    private DocumentModel model;
    private final Map<NewDocumentType, List<SDDocumentType>> scratchInheritsMap = new HashMap<NewDocumentType, List<SDDocumentType>>();

    public DocumentModelBuilder(DocumentModel model) {
        this.model = model;
        model.getDocumentManager().add(VespaDocumentType.INSTANCE);
    }

    public boolean valid() {
        return this.scratchInheritsMap.isEmpty();
    }

    public void addToModel(Collection<Search> searchList) {
        List<SDDocumentType> docList = new LinkedList<SDDocumentType>();
        for (Search search : searchList) {
            docList.add(search.getDocument());
        }
        docList = this.sortDocumentTypes(docList);
        this.addDocumentTypes(docList);
        Collection<Search> toAdd = this.tryAdd(searchList);
        while (!toAdd.isEmpty() && toAdd.size() < searchList.size()) {
            searchList = toAdd;
            toAdd = this.tryAdd(searchList);
        }
    }

    private List<SDDocumentType> sortDocumentTypes(List<SDDocumentType> docList) {
        HashSet<String> doneNames = new HashSet<String>();
        doneNames.add(SDDocumentType.VESPA_DOCUMENT.getName());
        LinkedList<SDDocumentType> doneList = new LinkedList<SDDocumentType>();
        List<SDDocumentType> prevList = null;
        List<SDDocumentType> nextList = docList;
        while (prevList == null || nextList.size() < prevList.size()) {
            prevList = nextList;
            nextList = new LinkedList<SDDocumentType>();
            for (SDDocumentType doc : prevList) {
                boolean isDone = true;
                for (SDDocumentType inherited : doc.getInheritedTypes()) {
                    if (doneNames.contains(inherited.getName())) continue;
                    isDone = false;
                    break;
                }
                if (isDone) {
                    doneNames.add(doc.getName());
                    doneList.add(doc);
                    continue;
                }
                nextList.add(doc);
            }
        }
        if (!nextList.isEmpty()) {
            throw new IllegalArgumentException("Could not resolve inheritance of document types " + DocumentModelBuilder.toString(prevList) + ".");
        }
        return doneList;
    }

    private static String toString(List<SDDocumentType> lst) {
        StringBuilder out = new StringBuilder();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            out.append("'").append(lst.get(i).getName()).append("'");
            if (i < len - 2) {
                out.append(", ");
                continue;
            }
            if (i >= len - 1) continue;
            out.append(" and ");
        }
        return out.toString();
    }

    private Collection<Search> tryAdd(Collection<Search> searchList) {
        ArrayList<Search> left = new ArrayList<Search>();
        for (Search search : searchList) {
            try {
                this.addToModel(search);
            }
            catch (RetryLaterException e) {
                left.add(search);
            }
        }
        return left;
    }

    public void addToModel(Search search) {
        SearchDef searchDef = new SearchDef(search.getName());
        DocumentModelBuilder.addSearchFields(search.extraFieldList(), searchDef);
        for (Field f : search.getDocument().fieldSet()) {
            DocumentModelBuilder.addSearchField((SDField)f, searchDef);
        }
        for (SDField field : search.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (searchDef.getFields().containsKey(attribute.getName())) continue;
                searchDef.add(new SearchField(new Field(attribute.getName(), (Field)field), !field.getIndices().isEmpty(), true));
            }
        }
        for (Field f : search.getDocument().fieldSet()) {
            DocumentModelBuilder.addAlias((SDField)f, searchDef);
        }
        this.model.getSearchManager().add(searchDef);
    }

    private static void addSearchFields(Collection<SDField> fields, SearchDef searchDef) {
        for (SDField field : fields) {
            DocumentModelBuilder.addSearchField(field, searchDef);
        }
    }

    private static void addSearchField(SDField field, SearchDef searchDef) {
        SearchField searchField = new SearchField(field, field.getIndices().containsKey(field.getName()) && field.getIndices().get(field.getName()).getType().equals((Object)Index.Type.VESPA), field.getAttributes().containsKey(field.getName()));
        searchDef.add(searchField);
        DocumentModelBuilder.addToView(field.getIndices().keySet(), (Field)searchField, searchDef);
    }

    private static void addAlias(SDField field, SearchDef searchDef) {
        for (Map.Entry<String, String> entry : field.getAliasToName().entrySet()) {
            searchDef.addAlias(entry.getKey(), entry.getValue());
        }
    }

    private static void addToView(Collection<String> views, Field field, SearchDef searchDef) {
        for (String viewName : views) {
            DocumentModelBuilder.addToView(viewName, field, searchDef);
        }
    }

    private static void addToView(String viewName, Field field, SearchDef searchDef) {
        if (searchDef.getViews().containsKey(viewName)) {
            searchDef.getViews().get(viewName).add(field);
        } else if (!searchDef.getFields().containsKey(viewName)) {
            FieldView view = new FieldView(viewName);
            view.add(field);
            searchDef.add(view);
        }
    }

    private void addDocumentTypes(List<SDDocumentType> docList) {
        LinkedList<NewDocumentType> lst = new LinkedList<NewDocumentType>();
        for (SDDocumentType sDDocumentType : docList) {
            lst.add(this.convert(sDDocumentType));
            this.model.getDocumentManager().add(lst.getLast());
        }
        for (NewDocumentType newDocumentType : lst) {
            DocumentModelBuilder.resolveTemporaries(newDocumentType.getAllTypes(), lst);
        }
    }

    private static void resolveTemporaries(DataTypeCollection dtc, Collection<NewDocumentType> docs) {
        for (DataType type : dtc.getTypes()) {
            DocumentModelBuilder.resolveTemporariesRecurse(type, dtc, docs);
        }
    }

    private static DataType resolveTemporariesRecurse(DataType type, DataTypeCollection repo, Collection<NewDocumentType> docs) {
        ReferenceDataType t;
        if (type instanceof TemporaryStructuredDataType) {
            DataType struct = repo.getDataType(type.getId());
            type = struct != null ? struct : DocumentModelBuilder.getDocumentType(docs, type.getId());
        } else if (type instanceof StructDataType) {
            StructDataType dt = (StructDataType)type;
            for (Field field : dt.getFields()) {
                if (field.getDataType() == type) continue;
                field.setDataType(DocumentModelBuilder.resolveTemporariesRecurse(field.getDataType(), repo, docs));
            }
        } else if (type instanceof MapDataType) {
            MapDataType t2 = (MapDataType)type;
            t2.setKeyType(DocumentModelBuilder.resolveTemporariesRecurse(t2.getKeyType(), repo, docs));
            t2.setValueType(DocumentModelBuilder.resolveTemporariesRecurse(t2.getValueType(), repo, docs));
        } else if (type instanceof CollectionDataType) {
            CollectionDataType t3 = (CollectionDataType)type;
            t3.setNestedType(DocumentModelBuilder.resolveTemporariesRecurse(t3.getNestedType(), repo, docs));
        } else if (type instanceof ReferenceDataType && (t = (ReferenceDataType)type).getTargetType() instanceof TemporaryStructuredDataType) {
            DataType targetType = DocumentModelBuilder.resolveTemporariesRecurse((DataType)t.getTargetType(), repo, docs);
            t.setTargetType((StructuredDataType)targetType);
        }
        return type;
    }

    private static NewDocumentType getDocumentType(Collection<NewDocumentType> docs, int id) {
        for (NewDocumentType doc : docs) {
            if (doc.getId() != id) continue;
            return doc;
        }
        return null;
    }

    private static void specialHandleAnnotationReference(NewDocumentType docType, Field field) {
        DataType fieldType = DocumentModelBuilder.specialHandleAnnotationReferenceRecurse(docType, field.getName(), field.getDataType());
        if (fieldType == null) {
            return;
        }
        field.setDataType(fieldType);
    }

    private static DataType specialHandleAnnotationReferenceRecurse(NewDocumentType docType, String fieldName, DataType dataType) {
        if (dataType instanceof TemporaryAnnotationReferenceDataType) {
            TemporaryAnnotationReferenceDataType refType = (TemporaryAnnotationReferenceDataType)dataType;
            if (refType.getId() != 0) {
                return null;
            }
            AnnotationType target = docType.getAnnotationType(refType.getTarget());
            if (target == null) {
                throw new RetryLaterException("Annotation '" + refType.getTarget() + "' in reference '" + fieldName + "' does not exist.");
            }
            dataType = new AnnotationReferenceDataType(target);
            DocumentModelBuilder.addType(docType, dataType);
            return dataType;
        }
        if (dataType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)dataType;
            DataType valueType = DocumentModelBuilder.specialHandleAnnotationReferenceRecurse(docType, fieldName, mapType.getValueType());
            if (valueType == null) {
                return null;
            }
            mapType = mapType.clone();
            mapType.setValueType(valueType);
            DocumentModelBuilder.addType(docType, (DataType)mapType);
            return mapType;
        }
        if (dataType instanceof CollectionDataType) {
            CollectionDataType lstType = (CollectionDataType)dataType;
            DataType nestedType = DocumentModelBuilder.specialHandleAnnotationReferenceRecurse(docType, fieldName, lstType.getNestedType());
            if (nestedType == null) {
                return null;
            }
            lstType = lstType.clone();
            lstType.setNestedType(nestedType);
            DocumentModelBuilder.addType(docType, (DataType)lstType);
            return lstType;
        }
        return null;
    }

    private static StructDataType handleStruct(NewDocumentType dt, SDDocumentType type) {
        StructDataType s = new StructDataType(type.getName());
        for (Field f : type.getDocumentType().contentStruct().getFieldsThisTypeOnly()) {
            DocumentModelBuilder.specialHandleAnnotationReference(dt, f);
            s.addField(f);
        }
        for (StructDataType inherited : type.getDocumentType().contentStruct().getInheritedTypes()) {
            s.inherit(inherited);
        }
        DocumentModelBuilder.extractNestedTypes(dt, (DataType)s);
        DocumentModelBuilder.addType(dt, (DataType)s);
        return s;
    }

    private static StructDataType handleStruct(NewDocumentType dt, StructDataType s) {
        for (Field f : s.getFieldsThisTypeOnly()) {
            DocumentModelBuilder.specialHandleAnnotationReference(dt, f);
        }
        DocumentModelBuilder.extractNestedTypes(dt, (DataType)s);
        DocumentModelBuilder.addType(dt, (DataType)s);
        return s;
    }

    private static boolean anyParentsHavePayLoad(SDAnnotationType sa, SDDocumentType sdoc) {
        if (sa.getInherits() != null) {
            AnnotationType tmp = sdoc.findAnnotation(sa.getInherits());
            SDAnnotationType inherited = (SDAnnotationType)tmp;
            return inherited.getSdDocType() != null || DocumentModelBuilder.anyParentsHavePayLoad(inherited, sdoc);
        }
        return false;
    }

    private NewDocumentType convert(SDDocumentType sdoc) {
        HashMap<AnnotationType, String> annotationInheritance = new HashMap<AnnotationType, String>();
        HashMap<StructDataType, CallSite> structInheritance = new HashMap<StructDataType, CallSite>();
        NewDocumentType dt = new NewDocumentType(new NewDocumentType.Name(sdoc.getName()), sdoc.getDocumentType().contentStruct(), sdoc.getFieldSets(), DocumentModelBuilder.convertDocumentReferencesToNames(sdoc.getDocumentReferences()), DocumentModelBuilder.convertTemporaryImportedFieldsToNames(sdoc.getTemporaryImportedFields()));
        for (SDDocumentType sDDocumentType : sdoc.getInheritedTypes()) {
            NewDocumentType.Name name = new NewDocumentType.Name(sDDocumentType.getName());
            NewDocumentType inherited = this.model.getDocumentManager().getDocumentType(name);
            if (inherited == null) continue;
            dt.inherit(inherited);
        }
        for (SDDocumentType sDDocumentType : sdoc.getTypes()) {
            if (sDDocumentType.isStruct()) {
                DocumentModelBuilder.handleStruct(dt, sDDocumentType);
                continue;
            }
            throw new IllegalArgumentException("Data type '" + sdoc.getName() + "' is not a struct => tostring='" + sdoc.toString() + "'.");
        }
        for (AnnotationType annotationType : sdoc.getAnnotations()) {
            dt.add(annotationType);
        }
        for (AnnotationType annotationType : sdoc.getAnnotations()) {
            StructDataType s;
            SDAnnotationType sa = (SDAnnotationType)annotationType;
            if (annotationType.getInheritedTypes().isEmpty() && sa.getInherits() != null) {
                annotationInheritance.put(annotationType, sa.getInherits());
            }
            if (annotationType.getDataType() != null) continue;
            if (sa.getSdDocType() != null) {
                s = DocumentModelBuilder.handleStruct(dt, sa.getSdDocType());
                annotationType.setDataType((DataType)s);
                if (sa.getInherits() == null) continue;
                structInheritance.put(s, (CallSite)((Object)("annotation." + sa.getInherits())));
                continue;
            }
            if (sa.getInherits() == null) continue;
            s = new StructDataType("annotation." + annotationType.getName());
            if (DocumentModelBuilder.anyParentsHavePayLoad(sa, sdoc)) {
                annotationType.setDataType((DataType)s);
                DocumentModelBuilder.addType(dt, (DataType)s);
            }
            structInheritance.put(s, (CallSite)((Object)("annotation." + sa.getInherits())));
        }
        for (Map.Entry entry : annotationInheritance.entrySet()) {
            ((AnnotationType)entry.getKey()).inherit(dt.getAnnotationType((String)entry.getValue()));
        }
        for (Map.Entry entry : structInheritance.entrySet()) {
            StructDataType s = (StructDataType)dt.getDataType((String)entry.getValue());
            if (s == null) continue;
            ((StructDataType)entry.getKey()).inherit(s);
        }
        DocumentModelBuilder.handleStruct(dt, sdoc.getDocumentType().contentStruct());
        DocumentModelBuilder.extractDataTypesFromFields(dt, sdoc.fieldSet());
        return dt;
    }

    private static Set<NewDocumentType.Name> convertDocumentReferencesToNames(Optional<DocumentReferences> documentReferences) {
        if (!documentReferences.isPresent()) {
            return Collections.emptySet();
        }
        return documentReferences.get().referenceMap().values().stream().map(documentReference -> documentReference.targetSearch().getDocument()).map(documentType -> new NewDocumentType.Name(documentType.getName())).collect(Collectors.toSet());
    }

    private static Set<String> convertTemporaryImportedFieldsToNames(TemporaryImportedFields importedFields) {
        if (importedFields == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(importedFields.fields().keySet());
    }

    private static void extractDataTypesFromFields(NewDocumentType dt, Collection<Field> fields) {
        for (Field f : fields) {
            DataType type = f.getDataType();
            if (!DocumentModelBuilder.testAddType(dt, type)) continue;
            DocumentModelBuilder.extractNestedTypes(dt, type);
            DocumentModelBuilder.addType(dt, type);
        }
    }

    private static void extractNestedTypes(NewDocumentType dt, DataType type) {
        if (type instanceof StructDataType) {
            StructDataType tmp = (StructDataType)type;
            DocumentModelBuilder.extractDataTypesFromFields(dt, tmp.getFieldsThisTypeOnly());
        } else {
            if (type instanceof DocumentType) {
                throw new IllegalArgumentException("Can not handle nested document definitions. In document type '" + dt.getName().toString() + "', we can not define document type '" + type.toString());
            }
            if (type instanceof CollectionDataType) {
                CollectionDataType tmp = (CollectionDataType)type;
                DocumentModelBuilder.extractNestedTypes(dt, tmp.getNestedType());
                DocumentModelBuilder.addType(dt, tmp.getNestedType());
            } else if (type instanceof MapDataType) {
                MapDataType tmp = (MapDataType)type;
                DocumentModelBuilder.extractNestedTypes(dt, tmp.getKeyType());
                DocumentModelBuilder.extractNestedTypes(dt, tmp.getValueType());
                DocumentModelBuilder.addType(dt, tmp.getKeyType());
                DocumentModelBuilder.addType(dt, tmp.getValueType());
            } else if (type instanceof TemporaryAnnotationReferenceDataType) {
                throw new IllegalArgumentException(type.toString());
            }
        }
    }

    private static boolean testAddType(NewDocumentType dt, DataType type) {
        return DocumentModelBuilder.internalAddType(dt, type, true);
    }

    private static boolean addType(NewDocumentType dt, DataType type) {
        return DocumentModelBuilder.internalAddType(dt, type, false);
    }

    private static boolean internalAddType(NewDocumentType dt, DataType type, boolean dryRun) {
        DataType oldType = dt.getDataTypeRecursive(type.getId());
        if (oldType == null) {
            if (!dryRun) {
                dt.add(type);
            }
            return true;
        }
        if (type instanceof StructDataType && oldType instanceof StructDataType) {
            StructDataType s = (StructDataType)type;
            StructDataType os = (StructDataType)oldType;
            if (os.getFieldCount() == 0 && s.getFieldCount() > os.getFieldCount()) {
                if (!dryRun) {
                    dt.replace(type);
                }
                return true;
            }
        }
        return false;
    }

    public static class RetryLaterException
    extends IllegalArgumentException {
        public RetryLaterException(String message) {
            super(message);
        }
    }
}

