/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import org.w3c.dom.Element;

public class DocprocOptionsBuilder {
    public static ContainerDocproc.Options build(Element spec) {
        return new ContainerDocproc.Options(DocprocOptionsBuilder.getCompression(spec), DocprocOptionsBuilder.getMaxMessagesInQueue(spec), DocprocOptionsBuilder.getSizeInMegabytes(spec.getAttribute("maxqueuebytesize")), DocprocOptionsBuilder.getTime(spec.getAttribute("maxqueuewait")), DocprocOptionsBuilder.getFactor(spec.getAttribute("maxconcurrentfactor")), DocprocOptionsBuilder.getFactor(spec.getAttribute("documentexpansionfactor")), DocprocOptionsBuilder.getInt(spec.getAttribute("containercorememory")));
    }

    private static Integer getInt(String integer) {
        return integer == null || integer.trim().isEmpty() ? null : Integer.valueOf(Integer.parseInt(integer));
    }

    private static boolean getCompression(Element spec) {
        return spec.hasAttribute("compressdocuments") && spec.getAttribute("compressdocuments").equals("true");
    }

    private static Double getFactor(String factor) {
        return factor == null || factor.trim().isEmpty() ? null : Double.valueOf(Double.parseDouble(factor));
    }

    private static Integer getMaxMessagesInQueue(Element spec) {
        Integer maxMessagesInQueue = null;
        if (spec.hasAttribute("maxmessagesinqueue")) {
            maxMessagesInQueue = Integer.valueOf(spec.getAttribute("maxmessagesinqueue"));
        }
        return maxMessagesInQueue;
    }

    private static Integer getSizeInMegabytes(String size) {
        Integer megabyteSize;
        if (size == null) {
            return null;
        }
        if ((size = size.trim()).isEmpty()) {
            return null;
        }
        if (size.endsWith("m")) {
            size = size.substring(0, size.length() - 1);
            megabyteSize = Integer.parseInt(size);
        } else if (size.endsWith("g")) {
            size = size.substring(0, size.length() - 1);
            megabyteSize = Integer.parseInt(size) * 1024;
        } else {
            throw new IllegalArgumentException("Heap sizes for docproc must be set to Xm or Xg, where X is an integer specifying megabytes or gigabytes, respectively.");
        }
        return megabyteSize;
    }

    private static Integer getTime(String intStr) {
        if (intStr == null) {
            return null;
        }
        if ((intStr = intStr.trim()).isEmpty()) {
            return null;
        }
        return 1000 * (int)Double.parseDouble(intStr);
    }
}

