/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.ConfigDefinitionStore;
import com.yahoo.config.model.deploy.SearchDocumentModel;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.provision.HostsXmlProvisioner;
import com.yahoo.config.model.provision.SingleNodeProvisioner;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SearchBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.container.search.QueryProfilesBuilder;
import com.yahoo.vespa.model.container.search.SemanticRuleBuilder;
import com.yahoo.vespa.model.container.search.SemanticRules;
import com.yahoo.vespa.model.search.NamedSchema;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;

public class DeployState
implements ConfigDefinitionStore {
    private final DeployLogger logger;
    private final FileRegistry fileRegistry;
    private final DocumentModel documentModel;
    private final List<NamedSchema> schemas;
    private final ApplicationPackage applicationPackage;
    private final Optional<ConfigDefinitionRepo> configDefinitionRepo;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final Optional<Model> previousModel;
    private final boolean accessLoggingEnabledByDefault;
    private final ModelContext.Properties properties;
    private final Version vespaVersion;
    private final Set<ContainerEndpoint> endpoints;
    private final Zone zone;
    private final QueryProfiles queryProfiles;
    private final SemanticRules semanticRules;
    private final ImportedMlModels importedModels;
    private final ValidationOverrides validationOverrides;
    private final Version wantedNodeVespaVersion;
    private final Optional<DockerImage> wantedDockerImageRepo;
    private final Instant now;
    private final HostProvisioner provisioner;
    private final Provisioned provisioned;
    private final Reindexing reindexing;
    private final RankProfileRegistry rankProfileRegistry;
    private Map<ConfigDefinitionKey, UnparsedConfigDefinition> existingConfigDefs = null;
    private final Map<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition> defArchive = new LinkedHashMap<ConfigDefinitionKey, com.yahoo.vespa.config.ConfigDefinition>();

    public static DeployState createTestState() {
        return new Builder().build();
    }

    public static DeployState createTestState(DeployLogger testLogger) {
        return new Builder().deployLogger(testLogger).build();
    }

    public static DeployState createTestState(ApplicationPackage applicationPackage) {
        return new Builder().applicationPackage(applicationPackage).build();
    }

    private DeployState(ApplicationPackage applicationPackage, SearchDocumentModel searchDocumentModel, RankProfileRegistry rankProfileRegistry, FileRegistry fileRegistry, DeployLogger deployLogger, Optional<HostProvisioner> hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Version vespaVersion, Optional<ApplicationPackage> permanentApplicationPackage, Optional<ConfigDefinitionRepo> configDefinitionRepo, Optional<Model> previousModel, Set<ContainerEndpoint> endpoints, Collection<MlModelImporter> modelImporters, Zone zone, QueryProfiles queryProfiles, SemanticRules semanticRules, Instant now, Version wantedNodeVespaVersion, boolean accessLoggingEnabledByDefault, Optional<DockerImage> wantedDockerImageRepo, Reindexing reindexing) {
        this.logger = deployLogger;
        this.fileRegistry = fileRegistry;
        this.rankProfileRegistry = rankProfileRegistry;
        this.applicationPackage = applicationPackage;
        this.properties = properties;
        this.vespaVersion = vespaVersion;
        this.previousModel = previousModel;
        this.accessLoggingEnabledByDefault = accessLoggingEnabledByDefault;
        this.provisioner = hostProvisioner.orElse(DeployState.getDefaultModelHostProvisioner(applicationPackage));
        this.provisioned = provisioned;
        this.schemas = searchDocumentModel.getSchemas();
        this.documentModel = searchDocumentModel.getDocumentModel();
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configDefinitionRepo = configDefinitionRepo;
        this.endpoints = Set.copyOf(endpoints);
        this.zone = zone;
        this.queryProfiles = queryProfiles;
        this.semanticRules = semanticRules;
        this.importedModels = DeployState.importMlModels(applicationPackage, modelImporters, deployLogger);
        ValidationOverrides suppliedValidationOverrides = applicationPackage.getValidationOverrides().map(ValidationOverrides::fromXml).orElse(ValidationOverrides.empty);
        this.validationOverrides = zone.environment().isManuallyDeployed() ? new ValidationOverrides.AllowAllValidationOverrides(suppliedValidationOverrides, deployLogger) : suppliedValidationOverrides;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
        this.now = now;
        this.wantedDockerImageRepo = wantedDockerImageRepo;
        this.reindexing = reindexing;
    }

    public static HostProvisioner getDefaultModelHostProvisioner(ApplicationPackage applicationPackage) {
        Object object;
        block8: {
            Reader hostsReader = applicationPackage.getHosts();
            try {
                Object object2 = object = hostsReader == null ? new SingleNodeProvisioner() : new HostsXmlProvisioner(hostsReader);
                if (hostsReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hostsReader != null) {
                        try {
                            hostsReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not read hosts.xml", e);
                }
            }
            hostsReader.close();
        }
        return object;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public final RankProfileRegistry rankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public ValidationOverrides validationOverrides() {
        return this.validationOverrides;
    }

    @Override
    public final Optional<com.yahoo.vespa.config.ConfigDefinition> getConfigDefinition(ConfigDefinitionKey defKey) {
        if (this.existingConfigDefs == null) {
            this.existingConfigDefs = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
            this.configDefinitionRepo.ifPresent(definitionRepo -> this.existingConfigDefs.putAll(DeployState.createLazyMapping(definitionRepo)));
            this.existingConfigDefs.putAll(this.applicationPackage.getAllExistingConfigDefs());
        }
        if (!this.existingConfigDefs.containsKey(defKey)) {
            return Optional.empty();
        }
        if (this.defArchive.get(defKey) != null) {
            return Optional.of(this.defArchive.get(defKey));
        }
        com.yahoo.vespa.config.ConfigDefinition def = this.existingConfigDefs.get(defKey).parse();
        this.defArchive.put(defKey, def);
        return Optional.of(def);
    }

    private static Map<ConfigDefinitionKey, UnparsedConfigDefinition> createLazyMapping(final ConfigDefinitionRepo configDefinitionRepo) {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> keyToRepo = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        for (final Map.Entry defEntry : configDefinitionRepo.getConfigDefinitions().entrySet()) {
            keyToRepo.put((ConfigDefinitionKey)defEntry.getKey(), new UnparsedConfigDefinition(){

                public com.yahoo.vespa.config.ConfigDefinition parse() {
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)((ConfigDefinition)configDefinitionRepo.getConfigDefinitions().get(defEntry.getKey())).getCNode());
                }

                public String getUnparsedContent() {
                    throw new UnsupportedOperationException("Cannot get unparsed content from " + defEntry.getKey());
                }
            });
        }
        return keyToRepo;
    }

    private static ImportedMlModels importMlModels(ApplicationPackage applicationPackage, Collection<MlModelImporter> modelImporters, DeployLogger deployLogger) {
        File importFrom = applicationPackage.getFileReference(ApplicationPackage.MODELS_DIR);
        ImportedMlModels importedModels = new ImportedMlModels(importFrom, modelImporters);
        for (Map.Entry entry : importedModels.getSkippedModels().entrySet()) {
            deployLogger.logApplicationPackage(Level.WARNING, "Skipping import of model " + (String)entry.getKey() + " as an exception occurred during import. Error: " + (String)entry.getValue());
        }
        return importedModels;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public List<NamedSchema> getSchemas() {
        return this.schemas;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public DeployLogger getDeployLogger() {
        return this.logger;
    }

    public boolean getAccessLoggingEnabledByDefault() {
        return this.accessLoggingEnabledByDefault;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public HostProvisioner getProvisioner() {
        return this.provisioner;
    }

    public Optional<ApplicationPackage> getPermanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public ModelContext.Properties getProperties() {
        return this.properties;
    }

    public ModelContext.FeatureFlags featureFlags() {
        return this.properties.featureFlags();
    }

    public Version getVespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Model> getPreviousModel() {
        return this.previousModel;
    }

    public boolean isHosted() {
        return this.properties.hostedVespa();
    }

    public Set<ContainerEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public Zone zone() {
        return this.zone;
    }

    public QueryProfiles getQueryProfiles() {
        return this.queryProfiles;
    }

    public SemanticRules getSemanticRules() {
        return this.semanticRules;
    }

    public ImportedMlModels getImportedModels() {
        return this.importedModels;
    }

    public Version getWantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public Optional<DockerImage> getWantedDockerImageRepo() {
        return this.wantedDockerImageRepo;
    }

    public Instant now() {
        return this.now;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.properties.endpointCertificateSecrets();
    }

    public Optional<String> tlsClientAuthority() {
        ApplicationFile caFile = this.applicationPackage.getClientSecurityFile();
        if (caFile.exists()) {
            try {
                String caPem = IOUtils.readAll((Reader)caFile.createReader());
                return Optional.of(caPem);
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed reading certificate from application: " + caFile.getPath(), e);
            }
        }
        return Optional.empty();
    }

    public Optional<Reindexing> reindexing() {
        return Optional.ofNullable(this.reindexing);
    }

    public static class Builder {
        private ApplicationPackage applicationPackage = MockApplicationPackage.createEmpty();
        private FileRegistry fileRegistry = new MockFileRegistry();
        private DeployLogger logger = new BaseDeployLogger();
        private Optional<HostProvisioner> hostProvisioner = Optional.empty();
        private Provisioned provisioned = new Provisioned();
        private Optional<ApplicationPackage> permanentApplicationPackage = Optional.empty();
        private ModelContext.Properties properties = new TestProperties();
        private Version version = new Version(1, 0, 0);
        private Optional<ConfigDefinitionRepo> configDefinitionRepo = Optional.empty();
        private Optional<Model> previousModel = Optional.empty();
        private Set<ContainerEndpoint> endpoints = Set.of();
        private Collection<MlModelImporter> modelImporters = Collections.emptyList();
        private Zone zone = Zone.defaultZone();
        private Instant now = Instant.now();
        private Version wantedNodeVespaVersion = Vtag.currentVersion;
        private boolean accessLoggingEnabledByDefault = true;
        private Optional<DockerImage> wantedDockerImageRepo = Optional.empty();
        private Reindexing reindexing = null;

        public Builder applicationPackage(ApplicationPackage applicationPackage) {
            this.applicationPackage = applicationPackage;
            return this;
        }

        public Builder fileRegistry(FileRegistry fileRegistry) {
            this.fileRegistry = fileRegistry;
            return this;
        }

        public Builder deployLogger(DeployLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder modelHostProvisioner(HostProvisioner modelProvisioner) {
            this.hostProvisioner = Optional.of(modelProvisioner);
            return this;
        }

        public Builder provisioned(Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public Builder permanentApplicationPackage(Optional<ApplicationPackage> permanentApplicationPackage) {
            this.permanentApplicationPackage = permanentApplicationPackage;
            return this;
        }

        public Builder properties(ModelContext.Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder vespaVersion(Version version) {
            this.version = version;
            return this;
        }

        public Builder configDefinitionRepo(ConfigDefinitionRepo configDefinitionRepo) {
            this.configDefinitionRepo = Optional.of(configDefinitionRepo);
            return this;
        }

        public Builder previousModel(Model previousModel) {
            this.previousModel = Optional.of(previousModel);
            return this;
        }

        public Builder endpoints(Set<ContainerEndpoint> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder modelImporters(Collection<MlModelImporter> modelImporters) {
            this.modelImporters = modelImporters;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder now(Instant now) {
            this.now = now;
            return this;
        }

        public Builder wantedNodeVespaVersion(Version version) {
            this.wantedNodeVespaVersion = version;
            return this;
        }

        public Builder wantedDockerImageRepo(Optional<DockerImage> dockerImageRepo) {
            this.wantedDockerImageRepo = dockerImageRepo;
            return this;
        }

        public Builder accessLoggingEnabledByDefault(boolean accessLoggingEnabledByDefault) {
            this.accessLoggingEnabledByDefault = accessLoggingEnabledByDefault;
            return this;
        }

        public Builder reindexing(Reindexing reindexing) {
            this.reindexing = Objects.requireNonNull(reindexing);
            return this;
        }

        public DeployState build() {
            return this.build(new ValidationParameters());
        }

        public DeployState build(ValidationParameters validationParameters) {
            RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
            QueryProfiles queryProfiles = new QueryProfilesBuilder().build(this.applicationPackage, this.logger);
            SemanticRules semanticRules = new SemanticRuleBuilder().build(this.applicationPackage);
            SearchDocumentModel searchDocumentModel = this.createSearchDocumentModel(rankProfileRegistry, this.logger, queryProfiles, validationParameters);
            return new DeployState(this.applicationPackage, searchDocumentModel, rankProfileRegistry, this.fileRegistry, this.logger, this.hostProvisioner, this.provisioned, this.properties, this.version, this.permanentApplicationPackage, this.configDefinitionRepo, this.previousModel, this.endpoints, this.modelImporters, this.zone, queryProfiles, semanticRules, this.now, this.wantedNodeVespaVersion, this.accessLoggingEnabledByDefault, this.wantedDockerImageRepo, this.reindexing);
        }

        private SearchDocumentModel createSearchDocumentModel(RankProfileRegistry rankProfileRegistry, DeployLogger logger, QueryProfiles queryProfiles, ValidationParameters validationParameters) {
            Collection readers = this.applicationPackage.getSearchDefinitions();
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
            SearchBuilder builder = new SearchBuilder(this.applicationPackage, rankProfileRegistry, queryProfiles.getRegistry());
            for (NamedReader reader : readers) {
                try {
                    String readerName = reader.getName();
                    String topLevelName = builder.importReader(reader, readerName, logger);
                    String sdName = Builder.stripSuffix(readerName, ".sd");
                    names.put(topLevelName, sdName);
                    if (sdName.equals(topLevelName)) continue;
                    throw new IllegalArgumentException("Schema definition file name ('" + sdName + "') and name of top level element ('" + topLevelName + "') are not equal for file '" + readerName + "'");
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Could not parse sd file '" + reader.getName() + "'", e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read sd file '" + reader.getName() + "'", e);
                }
                finally {
                    Builder.closeIgnoreException(reader.getReader());
                }
            }
            builder.build(!validationParameters.ignoreValidationErrors(), logger);
            return SearchDocumentModel.fromBuilderAndNames(builder, names);
        }

        private static String stripSuffix(String nodeName, String postfix) {
            assert (nodeName.endsWith(postfix));
            return nodeName.substring(0, nodeName.length() - postfix.length());
        }

        private static void closeIgnoreException(Reader reader) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

