/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.search.AttributeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.DocumentTypeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.IndexingScriptChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.StructFieldAttributeChangeValidator;
import com.yahoo.vespa.model.search.DocumentDatabase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class DocumentDatabaseChangeValidator {
    private final ClusterSpec.Id id;
    private final DocumentDatabase currentDatabase;
    private final NewDocumentType currentDocType;
    private final DocumentDatabase nextDatabase;
    private final NewDocumentType nextDocType;

    public DocumentDatabaseChangeValidator(ClusterSpec.Id id, DocumentDatabase currentDatabase, NewDocumentType currentDocType, DocumentDatabase nextDatabase, NewDocumentType nextDocType) {
        this.id = id;
        this.currentDatabase = currentDatabase;
        this.currentDocType = currentDocType;
        this.nextDatabase = nextDatabase;
        this.nextDocType = nextDocType;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAttributeChanges());
        result.addAll(this.validateStructFieldAttributeChanges(overrides, now));
        result.addAll(this.validateIndexingScriptChanges(overrides, now));
        result.addAll(this.validateDocumentTypeChanges(overrides, now));
        return result;
    }

    private List<VespaConfigChangeAction> validateAttributeChanges() {
        return new AttributeChangeValidator(this.id, this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.currentDatabase.getDerivedConfiguration().getIndexSchema(), this.currentDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDatabase.getDerivedConfiguration().getIndexSchema(), this.nextDocType).validate();
    }

    private List<VespaConfigChangeAction> validateStructFieldAttributeChanges(ValidationOverrides overrides, Instant now) {
        return new StructFieldAttributeChangeValidator(this.id, this.currentDocType, this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields()).validate(overrides, now);
    }

    private List<VespaConfigChangeAction> validateIndexingScriptChanges(ValidationOverrides overrides, Instant now) {
        return new IndexingScriptChangeValidator(this.id, this.currentDatabase.getDerivedConfiguration().getSearch(), this.nextDatabase.getDerivedConfiguration().getSearch()).validate(overrides, now);
    }

    private List<VespaConfigChangeAction> validateDocumentTypeChanges(ValidationOverrides overrides, Instant now) {
        return new DocumentTypeChangeValidator(this.id, this.currentDocType, this.nextDocType).validate();
    }
}

