/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class FileDistributionConfigProducer
extends AbstractConfigProducer {
    private final Map<Host, FileDistributionConfigProvider> fileDistributionConfigProviders = new IdentityHashMap<Host, FileDistributionConfigProvider>();
    private final FileDistributor fileDistributor;

    public FileDistributionConfigProducer(AbstractConfigProducer ancestor, FileRegistry fileRegistry, List<ConfigServerSpec> configServerSpec, boolean isHosted) {
        this(ancestor, new FileDistributor(fileRegistry, configServerSpec, isHosted));
    }

    private FileDistributionConfigProducer(AbstractConfigProducer parent, FileDistributor fileDistributor) {
        super(parent, "filedistribution");
        this.fileDistributor = fileDistributor;
    }

    public FileDistributor getFileDistributor() {
        return this.fileDistributor;
    }

    public void addFileDistributionConfigProducer(Host host, FileDistributionConfigProvider fileDistributionConfigProvider) {
        this.fileDistributionConfigProviders.put(host, fileDistributionConfigProvider);
    }

    public FileDistributionConfigProvider getConfigProducer(Host host) {
        return this.fileDistributionConfigProviders.get(host);
    }
}

