/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.application.validation.RestartConfigs;

@RestartConfigs(value={StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class, LoadTypeConfig.class, MetricsmanagerConfig.class})
public abstract class ContentNode
extends AbstractService
implements StorCommunicationmanagerConfig.Producer,
StorStatusConfig.Producer,
StorServerConfig.Producer {
    private final int distributionKey;
    private final String rootDirectory;
    private final boolean skipCommunicationManagerThread;
    private final boolean skipMbusRequestThread;
    private final boolean skipMbusReplyThread;
    private final boolean useDirectStorageApiRpc;

    public ContentNode(ModelContext.Properties properties, AbstractConfigProducer parent, String clusterName, String rootDirectory, int distributionKey) {
        super(parent, "" + distributionKey);
        this.distributionKey = distributionKey;
        this.skipCommunicationManagerThread = properties.skipCommunicationManagerThread();
        this.skipMbusRequestThread = properties.skipMbusRequestThread();
        this.skipMbusReplyThread = properties.skipMbusReplyThread();
        this.rootDirectory = rootDirectory;
        this.useDirectStorageApiRpc = properties.useDirectStorageApiRpc();
        this.initialize();
        this.setProp("clustertype", "content");
        this.setProp("clustername", clusterName);
        this.setProp("index", distributionKey);
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.root_folder(this.rootDirectory);
        builder.node_index(this.distributionKey);
    }

    private void initialize() {
        this.portsMeta.on(0).tag("messaging");
        this.portsMeta.on(1).tag("rpc").tag("status");
        this.portsMeta.on(2).tag("http").tag("status").tag("state");
    }

    @Override
    public int getPortCount() {
        return 3;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            from.allocatePort("messaging");
            from.allocatePort("rpc");
            from.allocatePort("http");
        } else {
            from.wantPort(start++, "messaging");
            from.wantPort(start++, "rpc");
            from.wantPort(start++, "http");
        }
    }

    public void getConfig(StorCommunicationmanagerConfig.Builder builder) {
        builder.mbusport(this.getRelativePort(0));
        builder.rpcport(this.getRelativePort(1));
        builder.skip_thread(this.skipCommunicationManagerThread);
        builder.mbus.skip_request_thread(this.skipMbusRequestThread);
        builder.mbus.skip_reply_thread(this.skipMbusReplyThread);
        builder.use_direct_storageapi_rpc(this.useDirectStorageApiRpc);
    }

    public void getConfig(StorStatusConfig.Builder builder) {
        builder.httpport(this.getRelativePort(2));
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(2);
    }
}

