/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class DocumentApiOptionsBuilder {
    private static final Logger log = Logger.getLogger(DocumentApiOptionsBuilder.class.getName());

    public static ContainerDocumentApi.Options build(Element spec) {
        return new ContainerDocumentApi.Options(DocumentApiOptionsBuilder.getBindings(spec), DocumentApiOptionsBuilder.threadpoolOptions(spec, "http-client-api"));
    }

    private static ContainerThreadpool.UserOptions threadpoolOptions(Element spec, String elementName) {
        Element element = XML.getChild((Element)spec, (String)elementName);
        if (element == null) {
            return null;
        }
        return ContainerThreadpool.UserOptions.fromXml(element).orElse(null);
    }

    private static List<String> getBindings(Element spec) {
        List bindingElems = XML.getChildren((Element)spec, (String)"binding");
        if (bindingElems.isEmpty()) {
            return List.of();
        }
        ArrayList<String> bindings = new ArrayList<String>();
        for (Element e : bindingElems) {
            String binding = DocumentApiOptionsBuilder.getBinding(e);
            bindings.add(binding);
        }
        return bindings;
    }

    private static String getBinding(Element e) {
        Object binding = XML.getValue((Element)e);
        if (!((String)binding).endsWith("/")) {
            log.warning("Adding a trailing '/' to the document-api binding: " + (String)binding + " -> " + (String)binding + "/");
            binding = (String)binding + "/";
        }
        return binding;
    }
}

