/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaReindexAction;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IndexingModeChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, Instant now) {
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        for (Map.Entry<String, ContentCluster> currentEntry : currentModel.getContentClusters().entrySet()) {
            ContentCluster nextCluster = nextModel.getContentClusters().get(currentEntry.getKey());
            if (nextCluster == null) continue;
            actions.addAll(IndexingModeChangeValidator.validateContentCluster(currentEntry.getValue(), nextCluster, overrides, now));
        }
        return actions;
    }

    private static List<ConfigChangeAction> validateContentCluster(ContentCluster currentCluster, ContentCluster nextCluster, ValidationOverrides overrides, Instant now) {
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        ContentSearchCluster currentSearchCluster = currentCluster.getSearch();
        ContentSearchCluster nextSearchCluster = nextCluster.getSearch();
        IndexingModeChangeValidator.findDocumentTypesWithActionableIndexingModeChange(actions, overrides, nextCluster, now, IndexingModeChangeValidator.toDocumentTypeNames(currentSearchCluster.getDocumentTypesWithStreamingCluster()), IndexingModeChangeValidator.toDocumentTypeNames(nextSearchCluster.getDocumentTypesWithIndexedCluster()), "streaming", "indexed");
        IndexingModeChangeValidator.findDocumentTypesWithActionableIndexingModeChange(actions, overrides, nextCluster, now, IndexingModeChangeValidator.toDocumentTypeNames(currentSearchCluster.getDocumentTypesWithIndexedCluster()), IndexingModeChangeValidator.toDocumentTypeNames(nextSearchCluster.getDocumentTypesWithStreamingCluster()), "indexed", "streaming");
        IndexingModeChangeValidator.findDocumentTypesWithActionableIndexingModeChange(actions, overrides, nextCluster, now, IndexingModeChangeValidator.toDocumentTypeNames(currentSearchCluster.getDocumentTypesWithStoreOnly()), IndexingModeChangeValidator.toDocumentTypeNames(nextSearchCluster.getDocumentTypesWithIndexedCluster()), "store-only", "indexed");
        IndexingModeChangeValidator.findDocumentTypesWithActionableIndexingModeChange(actions, overrides, nextCluster, now, IndexingModeChangeValidator.toDocumentTypeNames(currentSearchCluster.getDocumentTypesWithIndexedCluster()), IndexingModeChangeValidator.toDocumentTypeNames(nextSearchCluster.getDocumentTypesWithStoreOnly()), "indexed", "store-only");
        return actions;
    }

    private static void findDocumentTypesWithActionableIndexingModeChange(List<ConfigChangeAction> actions, ValidationOverrides overrides, ContentCluster nextCluster, Instant now, Set<String> currentTypes, Set<String> nextTypes, String currentIndexMode, String nextIndexingMode) {
        for (String type : nextTypes) {
            if (!currentTypes.contains(type)) continue;
            List<ServiceInfo> services = nextCluster.getSearch().getSearchNodes().stream().map(AbstractService::getServiceInfo).collect(Collectors.toList());
            actions.add(VespaReindexAction.of(nextCluster.id(), ValidationId.indexModeChange.value(), overrides, String.format("Document type '%s' in cluster '%s' changed indexing mode from '%s' to '%s'", type, nextCluster.getName(), currentIndexMode, nextIndexingMode), services, type, now));
        }
    }

    private static Set<String> toDocumentTypeNames(List<NewDocumentType> types) {
        return types.stream().map(type -> type.getFullName().getName()).collect(Collectors.toSet());
    }
}

