/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.documentapi.DocumentAccessProvider;
import com.yahoo.container.di.config.PlatformBundlesConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingController;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.xml.PlatformBundles;
import java.util.Set;
import java.util.TreeSet;

@RestartConfigs(value={FleetcontrollerConfig.class, ZookeeperServerConfig.class})
public class ClusterControllerContainer
extends Container
implements PlatformBundlesConfig.Producer,
ZookeeperServerConfig.Producer {
    private static final ComponentSpecification CLUSTERCONTROLLER_BUNDLE = new ComponentSpecification("clustercontroller-apps");
    private static final ComponentSpecification ZOOKEEPER_SERVER_BUNDLE = new ComponentSpecification("zookeeper-server");
    private final Set<String> bundles = new TreeSet<String>();

    public ClusterControllerContainer(AbstractConfigProducer<?> parent, int index, boolean runStandaloneZooKeeper, boolean isHosted, ReindexingContext reindexingContext) {
        super(parent, "" + index, index, isHosted);
        this.addHandler("clustercontroller-status", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.StatusHandler", "/clustercontroller-status/*");
        this.addHandler("clustercontroller-state-restapi-v2", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.StateRestApiV2Handler", "/cluster/v2/*");
        if (runStandaloneZooKeeper) {
            this.addComponent("clustercontroller-zkrunner", "com.yahoo.vespa.zookeeper.VespaZooKeeperServerImpl", ZOOKEEPER_SERVER_BUNDLE);
            this.addComponent("clustercontroller-zkprovider", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.StandaloneZooKeeperProvider", CLUSTERCONTROLLER_BUNDLE);
        } else {
            this.addComponent("clustercontroller-zkrunner", "com.yahoo.vespa.zookeeper.DummyVespaZooKeeperServer", ZOOKEEPER_SERVER_BUNDLE);
            this.addComponent("clustercontroller-zkprovider", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.DummyZooKeeperProvider", CLUSTERCONTROLLER_BUNDLE);
        }
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.jsonAccessLog, "controller", isHosted));
        this.addFileBundle("clustercontroller-apps");
        this.addFileBundle("clustercontroller-apputil");
        this.addFileBundle("clustercontroller-core");
        this.addFileBundle("clustercontroller-utils");
        this.addFileBundle("zookeeper-server");
        this.configureReindexing(reindexingContext);
    }

    @Override
    public int getWantedPort() {
        return 19050;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.index() == 0;
    }

    @Override
    public ContainerServiceType myServiceType() {
        return ContainerServiceType.CLUSTERCONTROLLER_CONTAINER;
    }

    private void addHandler(Handler h, String path) {
        h.addServerBindings(SystemBindingPattern.fromHttpPath(path));
        super.addHandler(h);
    }

    private void addFileBundle(String bundleName) {
        this.bundles.add(PlatformBundles.absoluteBundlePath(bundleName).toString());
    }

    private ComponentModel createComponentModel(String id, String className, ComponentSpecification bundle) {
        return new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification(id), new ComponentSpecification(className), bundle));
    }

    private void addComponent(String id, String className, ComponentSpecification bundle) {
        this.addComponent(new Component(this.createComponentModel(id, className, bundle)));
    }

    private void addHandler(String id, String className, String path) {
        this.addHandler(new Handler(this.createComponentModel(id, className, CLUSTERCONTROLLER_BUNDLE)), path);
    }

    private void configureReindexing(ReindexingContext context) {
        if (context != null) {
            this.addFileBundle("clustercontroller-reindexer");
            this.addComponent(new ReindexingController(context));
            this.addComponent(new SimpleComponent(DocumentAccessProvider.class.getName()));
        }
    }

    public void getConfig(PlatformBundlesConfig.Builder builder) {
        this.bundles.forEach(arg_0 -> ((PlatformBundlesConfig.Builder)builder).bundlePaths(arg_0));
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }
}

