/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelRepoAdder;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.VespaModel;
import java.util.stream.Stream;

public final class ConfigModelContext {
    private final AbstractConfigProducer<?> parent;
    private final String producerId;
    private final DeployState deployState;
    private final VespaModel vespaModel;
    private final ConfigModelRepoAdder configModelRepoAdder;
    private final ApplicationType applicationType;

    private ConfigModelContext(ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, AbstractConfigProducer<?> parent, String producerId) {
        this.applicationType = applicationType;
        this.deployState = deployState;
        this.vespaModel = vespaModel;
        this.configModelRepoAdder = configModelRepoAdder;
        this.parent = parent;
        this.producerId = producerId;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.deployState.getApplicationPackage();
    }

    public String getProducerId() {
        return this.producerId;
    }

    public AbstractConfigProducer<?> getParentProducer() {
        return this.parent;
    }

    public DeployLogger getDeployLogger() {
        return this.deployState.getDeployLogger();
    }

    public DeployState getDeployState() {
        return this.deployState;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public VespaModel vespaModel() {
        return this.vespaModel;
    }

    public ModelContext.Properties properties() {
        return this.deployState.getProperties();
    }

    public ConfigModelRepoAdder getConfigModelRepoAdder() {
        return this.configModelRepoAdder;
    }

    public ConfigModelContext withParent(AbstractConfigProducer<?> newParent) {
        return ConfigModelContext.create(this.deployState, this.vespaModel, this.configModelRepoAdder, newParent, this.producerId);
    }

    public ConfigModelContext withId(String producerId) {
        return ConfigModelContext.create(this.deployState, this.vespaModel, this.configModelRepoAdder, this.parent, producerId);
    }

    public ConfigModelContext with(VespaModel vespaModel) {
        return ConfigModelContext.create(this.deployState, vespaModel, this.configModelRepoAdder, this.parent, this.producerId);
    }

    public static ConfigModelContext create(DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, AbstractConfigProducer<?> parent, String producerId) {
        return new ConfigModelContext(ApplicationType.DEFAULT, deployState, vespaModel, configModelRepoAdder, parent, producerId);
    }

    public static ConfigModelContext create(ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, AbstractConfigProducer<?> parent, String producerId) {
        return new ConfigModelContext(applicationType, deployState, vespaModel, configModelRepoAdder, parent, producerId);
    }

    public static enum ApplicationType {
        DEFAULT("default"),
        HOSTED_INFRASTRUCTURE("hosted-infrastructure");

        private final String type;

        private ApplicationType(String type) {
            this.type = type;
        }

        public static ApplicationType fromString(String value) {
            return Stream.of(ApplicationType.values()).filter(applicationType -> applicationType.type.equals(value)).findFirst().orElse(DEFAULT);
        }
    }
}

