/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.config.core.StateserverConfig;
import com.yahoo.vespa.model.AbstractService;

public class Slobrok
extends AbstractService
implements StateserverConfig.Producer {
    private static final long serialVersionUID = 1L;

    public void getConfig(StateserverConfig.Builder builder) {
        builder.httpport(this.getStatePort());
    }

    public Slobrok(AbstractConfigProducer parent, int index) {
        super(parent, "slobrok." + index);
        this.portsMeta.on(0).tag("rpc").tag("admin").tag("status");
        this.portsMeta.on(1).tag("http").tag("state");
        this.setProp("index", index);
        this.setProp("clustertype", "slobrok");
        this.setProp("clustername", "admin");
    }

    @Override
    public boolean requiresConsecutivePorts() {
        return false;
    }

    @Override
    public int getWantedPort() {
        if (this.getId() == 1) {
            return 19099;
        }
        return 0;
    }

    @Override
    public String getStartupCommand() {
        return "exec $ROOT/sbin/vespa-slobrok -p " + this.getPort() + " -c " + this.getConfigId();
    }

    @Override
    public int getPortCount() {
        return 2;
    }

    private String getPort() {
        return String.valueOf(this.getRelativePort(0));
    }

    public int getStatePort() {
        return this.getRelativePort(1);
    }

    public String getConnectionSpec() {
        return "tcp/" + this.getHostName() + ":" + this.getPort();
    }
}

