/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.MapEvaluationTypeContext;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.expressiontransforms.ExpressionTransforms;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.vespa.model.VespaModel;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RankProfile
implements Serializable,
Cloneable {
    private final String name;
    private final Search search;
    private final VespaModel model;
    private String inheritedName = null;
    protected MatchPhaseSettings matchPhaseSettings = null;
    protected Set<RankSetting> rankSettings = new LinkedHashSet<RankSetting>();
    private RankingExpression firstPhaseRanking = null;
    private RankingExpression secondPhaseRanking = null;
    private int rerankCount = -1;
    private int keepRankCount = -1;
    private int numThreadsPerSearch = -1;
    private int minHitsPerThread = -1;
    private int numSearchPartitions = -1;
    private Double termwiseLimit = null;
    private double rankScoreDropLimit = -1.7976931348623157E308;
    private Set<ReferenceNode> summaryFeatures;
    private Set<ReferenceNode> rankFeatures;
    private Map<String, List<RankProperty>> rankProperties = new LinkedHashMap<String, List<RankProperty>>();
    private Boolean ignoreDefaultRankFeatures = null;
    private Map<String, RankingExpressionFunction> functions = new LinkedHashMap<String, RankingExpressionFunction>();
    private Set<String> filterFields = new HashSet<String>();
    private final RankProfileRegistry rankProfileRegistry;
    private Map<String, Value> constants = new HashMap<String, Value>();
    private final TypeSettings attributeTypes = new TypeSettings();
    private final TypeSettings queryFeatureTypes = new TypeSettings();

    public RankProfile(String name, Search search, RankProfileRegistry rankProfileRegistry) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.search = Objects.requireNonNull(search, "search cannot be null");
        this.model = null;
        this.rankProfileRegistry = rankProfileRegistry;
    }

    public RankProfile(String name, VespaModel model, RankProfileRegistry rankProfileRegistry) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.search = null;
        this.model = Objects.requireNonNull(model, "model cannot be null");
        this.rankProfileRegistry = rankProfileRegistry;
    }

    public String getName() {
        return this.name;
    }

    public Search getSearch() {
        return this.search;
    }

    public ApplicationPackage applicationPackage() {
        return this.search != null ? this.search.applicationPackage() : this.model.applicationPackage();
    }

    public RankingConstants rankingConstants() {
        return this.search != null ? this.search.rankingConstants() : this.model.rankingConstants();
    }

    private Stream<ImmutableSDField> allFields() {
        return this.search != null ? this.search.allFields() : Stream.empty();
    }

    private Stream<ImmutableSDField> allImportedFields() {
        return this.search != null ? this.search.allImportedFields() : Stream.empty();
    }

    public void setInherited(String inheritedName) {
        this.inheritedName = inheritedName;
    }

    public String getInheritedName() {
        return this.inheritedName;
    }

    public RankProfile getInherited() {
        if (this.getSearch() == null) {
            return this.getInheritedFromRegistry(this.inheritedName);
        }
        RankProfile inheritedInThisSearch = this.rankProfileRegistry.get(this.search, this.inheritedName);
        if (inheritedInThisSearch != null) {
            return inheritedInThisSearch;
        }
        return this.getInheritedFromRegistry(this.inheritedName);
    }

    private RankProfile getInheritedFromRegistry(String inheritedName) {
        for (RankProfile r : this.rankProfileRegistry.all()) {
            if (!r.getName().equals(inheritedName)) continue;
            return r;
        }
        return null;
    }

    public boolean inherits(String name) {
        for (RankProfile parent = this.getInherited(); parent != null; parent = parent.getInherited()) {
            if (!parent.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setMatchPhaseSettings(MatchPhaseSettings settings) {
        settings.checkValid();
        this.matchPhaseSettings = settings;
    }

    public MatchPhaseSettings getMatchPhaseSettings() {
        MatchPhaseSettings settings = this.matchPhaseSettings;
        if (settings != null) {
            return settings;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getMatchPhaseSettings();
        }
        return null;
    }

    public void addRankSetting(RankSetting rankSetting) {
        this.rankSettings.add(rankSetting);
    }

    public void addRankSetting(String fieldName, RankSetting.Type type, Object value) {
        this.addRankSetting(new RankSetting(fieldName, type, value));
    }

    public RankSetting getDeclaredRankSetting(String field, RankSetting.Type type) {
        Iterator<RankSetting> i = this.declaredRankSettingIterator();
        while (i.hasNext()) {
            RankSetting setting = i.next();
            if (!setting.getFieldName().equals(field) || !setting.getType().equals((Object)type)) continue;
            return setting;
        }
        return null;
    }

    public RankSetting getRankSetting(String field, RankSetting.Type type) {
        RankSetting rankSetting = this.getDeclaredRankSetting(field, type);
        if (rankSetting != null) {
            return rankSetting;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankSetting(field, type);
        }
        return null;
    }

    public Iterator<RankSetting> declaredRankSettingIterator() {
        return Collections.unmodifiableSet(this.rankSettings).iterator();
    }

    public Iterator<RankSetting> rankSettingIterator() {
        return this.rankSettings().iterator();
    }

    public Set<RankSetting> rankSettings() {
        LinkedHashSet<RankSetting> allSettings = new LinkedHashSet<RankSetting>(this.rankSettings);
        RankProfile parent = this.getInherited();
        if (parent != null) {
            allSettings.addAll(parent.rankSettings());
        }
        return allSettings;
    }

    public void addConstant(String name, Value value) {
        this.constants.put(name, value.freeze());
    }

    public void addConstantTensor(String name, TensorValue value) {
        this.addConstant(name, (Value)value);
    }

    public Map<String, Value> getConstants() {
        if (this.constants.isEmpty()) {
            return this.getInherited() != null ? this.getInherited().getConstants() : Collections.emptyMap();
        }
        if (this.getInherited() == null || this.getInherited().getConstants().isEmpty()) {
            return Collections.unmodifiableMap(this.constants);
        }
        HashMap<String, Value> combinedConstants = new HashMap<String, Value>(this.getInherited().getConstants());
        combinedConstants.putAll(this.constants);
        return combinedConstants;
    }

    public void addAttributeType(String attributeName, String attributeType) {
        this.attributeTypes.addType(attributeName, attributeType);
    }

    public Map<String, String> getAttributeTypes() {
        return this.attributeTypes.getTypes();
    }

    public void addQueryFeatureType(String queryFeature, String queryFeatureType) {
        this.queryFeatureTypes.addType(queryFeature, queryFeatureType);
    }

    public Map<String, String> getQueryFeatureTypes() {
        return this.queryFeatureTypes.getTypes();
    }

    public RankingExpression getFirstPhaseRanking() {
        if (this.firstPhaseRanking != null) {
            return this.firstPhaseRanking;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getFirstPhaseRanking();
        }
        return null;
    }

    public void setFirstPhaseRanking(RankingExpression rankingExpression) {
        this.firstPhaseRanking = rankingExpression;
    }

    public void setFirstPhaseRanking(String expression) {
        try {
            this.firstPhaseRanking = this.parseRankingExpression("firstphase", expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal first phase ranking function", e);
        }
    }

    public RankingExpression getSecondPhaseRanking() {
        if (this.secondPhaseRanking != null) {
            return this.secondPhaseRanking;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getSecondPhaseRanking();
        }
        return null;
    }

    public void setSecondPhaseRanking(RankingExpression rankingExpression) {
        this.secondPhaseRanking = rankingExpression;
    }

    public void setSecondPhaseRanking(String expression) {
        try {
            this.secondPhaseRanking = this.parseRankingExpression("secondphase", expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal second phase ranking function", e);
        }
    }

    public Set<ReferenceNode> getSummaryFeatures() {
        if (this.summaryFeatures != null) {
            return Collections.unmodifiableSet(this.summaryFeatures);
        }
        if (this.getInherited() != null) {
            return this.getInherited().getSummaryFeatures();
        }
        return Collections.emptySet();
    }

    public void addSummaryFeature(ReferenceNode feature) {
        if (this.summaryFeatures == null) {
            this.summaryFeatures = new LinkedHashSet<ReferenceNode>();
        }
        this.summaryFeatures.add(feature);
    }

    public void addSummaryFeatures(FeatureList features) {
        for (ReferenceNode feature : features) {
            this.addSummaryFeature(feature);
        }
    }

    public Set<ReferenceNode> getRankFeatures() {
        if (this.rankFeatures != null) {
            return Collections.unmodifiableSet(this.rankFeatures);
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankFeatures();
        }
        return Collections.emptySet();
    }

    public void addRankFeature(ReferenceNode feature) {
        if (this.rankFeatures == null) {
            this.rankFeatures = new LinkedHashSet<ReferenceNode>();
        }
        this.rankFeatures.add(feature);
    }

    public void addRankFeatures(FeatureList features) {
        for (ReferenceNode feature : features) {
            this.addRankFeature(feature);
        }
    }

    public List<RankProperty> getRankProperties() {
        ArrayList<RankProperty> properties = new ArrayList<RankProperty>();
        for (List<RankProperty> propertyList : this.getRankPropertyMap().values()) {
            properties.addAll(propertyList);
        }
        return Collections.unmodifiableList(properties);
    }

    public Map<String, List<RankProperty>> getRankPropertyMap() {
        if (this.rankProperties.size() == 0 && this.getInherited() == null) {
            return Collections.emptyMap();
        }
        if (this.rankProperties.size() == 0) {
            return this.getInherited().getRankPropertyMap();
        }
        if (this.getInherited() == null) {
            return Collections.unmodifiableMap(this.rankProperties);
        }
        LinkedHashMap<String, List<RankProperty>> combined = new LinkedHashMap<String, List<RankProperty>>(this.getInherited().getRankPropertyMap());
        combined.putAll(this.rankProperties);
        return Collections.unmodifiableMap(combined);
    }

    public void addRankProperty(String name, String parameter) {
        this.addRankProperty(new RankProperty(name, parameter));
    }

    private void addRankProperty(RankProperty rankProperty) {
        List<RankProperty> properties = this.rankProperties.get(rankProperty.getName());
        if (properties == null) {
            properties = new ArrayList<RankProperty>(1);
            this.rankProperties.put(rankProperty.getName(), properties);
        }
        properties.add(rankProperty);
    }

    public String toString() {
        return "rank profile '" + this.getName() + "'";
    }

    public int getRerankCount() {
        return this.rerankCount < 0 && this.getInherited() != null ? this.getInherited().getRerankCount() : this.rerankCount;
    }

    public int getNumThreadsPerSearch() {
        return this.numThreadsPerSearch < 0 && this.getInherited() != null ? this.getInherited().getNumThreadsPerSearch() : this.numThreadsPerSearch;
    }

    public void setNumThreadsPerSearch(int numThreads) {
        this.numThreadsPerSearch = numThreads;
    }

    public int getMinHitsPerThread() {
        return this.minHitsPerThread < 0 && this.getInherited() != null ? this.getInherited().getMinHitsPerThread() : this.minHitsPerThread;
    }

    public void setMinHitsPerThread(int minHits) {
        this.minHitsPerThread = minHits;
    }

    public void setNumSearchPartitions(int numSearchPartitions) {
        this.numSearchPartitions = numSearchPartitions;
    }

    public int getNumSearchPartitions() {
        return this.numSearchPartitions < 0 && this.getInherited() != null ? this.getInherited().getNumSearchPartitions() : this.numSearchPartitions;
    }

    public double getTermwiseLimit() {
        return this.termwiseLimit == null && this.getInherited() != null ? this.getInherited().getTermwiseLimit() : (this.termwiseLimit != null ? this.termwiseLimit : 1.0);
    }

    public void setTermwiseLimit(double termwiseLimit) {
        this.termwiseLimit = termwiseLimit;
    }

    public void setRerankCount(int rerankCount) {
        this.rerankCount = rerankCount;
    }

    public void setIgnoreDefaultRankFeatures(Boolean ignoreDefaultRankFeatures) {
        this.ignoreDefaultRankFeatures = ignoreDefaultRankFeatures;
    }

    public boolean getIgnoreDefaultRankFeatures() {
        if (this.ignoreDefaultRankFeatures != null) {
            return this.ignoreDefaultRankFeatures;
        }
        return this.getInherited() != null && this.getInherited().getIgnoreDefaultRankFeatures();
    }

    public void addFunction(String name, List<String> arguments, String expression, boolean inline) {
        try {
            this.addFunction(new ExpressionFunction(name, arguments, this.parseRankingExpression(name, expression)), inline);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse function '" + name + "'", e);
        }
    }

    public RankingExpressionFunction addFunction(ExpressionFunction function, boolean inline) {
        RankingExpressionFunction rankingExpressionFunction = new RankingExpressionFunction(function, inline);
        this.functions.put(function.getName(), rankingExpressionFunction);
        return rankingExpressionFunction;
    }

    public Map<String, RankingExpressionFunction> getFunctions() {
        if (this.functions.isEmpty() && this.getInherited() == null) {
            return Collections.emptyMap();
        }
        if (this.functions.isEmpty()) {
            return this.getInherited().getFunctions();
        }
        if (this.getInherited() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, RankingExpressionFunction>(this.functions));
        }
        LinkedHashMap<String, RankingExpressionFunction> allFunctions = new LinkedHashMap<String, RankingExpressionFunction>(this.getInherited().getFunctions());
        allFunctions.putAll(this.functions);
        return Collections.unmodifiableMap(allFunctions);
    }

    public int getKeepRankCount() {
        if (this.keepRankCount >= 0) {
            return this.keepRankCount;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getKeepRankCount();
        }
        return -1;
    }

    public void setKeepRankCount(int rerankArraySize) {
        this.keepRankCount = rerankArraySize;
    }

    public double getRankScoreDropLimit() {
        if (this.rankScoreDropLimit > -1.7976931348623157E308) {
            return this.rankScoreDropLimit;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankScoreDropLimit();
        }
        return this.rankScoreDropLimit;
    }

    public void setRankScoreDropLimit(double rankScoreDropLimit) {
        this.rankScoreDropLimit = rankScoreDropLimit;
    }

    public Set<String> filterFields() {
        return this.filterFields;
    }

    public Set<String> allFilterFields() {
        RankProfile parent = this.getInherited();
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        if (parent != null) {
            retval.addAll(parent.allFilterFields());
        }
        retval.addAll(this.filterFields());
        return retval;
    }

    private RankingExpression parseRankingExpression(String expressionName, String expression) throws ParseException {
        RankingExpression rankingExpression;
        block10: {
            if (expression.trim().length() == 0) {
                throw new ParseException("Encountered an empty ranking expression in " + this.getName() + ", " + expressionName + ".");
            }
            Reader rankingExpressionReader = this.openRankingExpressionReader(expressionName, expression.trim());
            try {
                rankingExpression = new RankingExpression(expressionName, rankingExpressionReader);
                if (rankingExpressionReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (rankingExpressionReader != null) {
                        try {
                            rankingExpressionReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
                    ParseException exception = new ParseException("Could not parse ranking expression '" + expression.trim() + "' in " + this.getName() + ", " + expressionName + ".");
                    throw (ParseException)exception.initCause(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException parsing ranking expression '" + expressionName + "'");
                }
            }
            rankingExpressionReader.close();
        }
        return rankingExpression;
    }

    private Reader openRankingExpressionReader(String expName, String expression) {
        File file;
        if (!expression.startsWith("file:")) {
            return new StringReader(expression);
        }
        Object fileName = expression.substring("file:".length()).trim();
        if (!((String)fileName).endsWith(".expression")) {
            fileName = (String)fileName + ".expression";
        }
        if (!(file = new File((String)fileName)).isAbsolute() && file.getPath().contains("/")) {
            throw new IllegalArgumentException("In " + this.getName() + ", " + expName + ", ranking references file '" + file + "' in subdirectory, which is not supported.");
        }
        return this.search.getRankingExpression((String)fileName);
    }

    public RankProfile clone() {
        try {
            RankProfile clone = (RankProfile)super.clone();
            clone.rankSettings = new LinkedHashSet<RankSetting>(this.rankSettings);
            clone.matchPhaseSettings = this.matchPhaseSettings;
            clone.summaryFeatures = this.summaryFeatures != null ? new LinkedHashSet<ReferenceNode>(this.summaryFeatures) : null;
            clone.rankFeatures = this.rankFeatures != null ? new LinkedHashSet<ReferenceNode>(this.rankFeatures) : null;
            clone.rankProperties = new LinkedHashMap<String, List<RankProperty>>(this.rankProperties);
            clone.functions = new LinkedHashMap<String, RankingExpressionFunction>(this.functions);
            clone.filterFields = new HashSet<String>(this.filterFields);
            clone.constants = new HashMap<String, Value>(this.constants);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public RankProfile compile(QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        try {
            RankProfile compiled = this.clone();
            compiled.compileThis(queryProfiles, importedModels);
            return compiled;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Rank profile '" + this.getName() + "' is invalid", e);
        }
    }

    private void compileThis(QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        this.checkNameCollisions(this.getFunctions(), this.getConstants());
        ExpressionTransforms expressionTransforms = new ExpressionTransforms();
        Map<String, RankingExpressionFunction> inlineFunctions = this.compileFunctions(this::getInlineFunctions, queryProfiles, importedModels, Collections.emptyMap(), expressionTransforms);
        this.functions = this.compileFunctions(this::getFunctions, queryProfiles, importedModels, inlineFunctions, expressionTransforms);
        this.firstPhaseRanking = this.compile(this.getFirstPhaseRanking(), queryProfiles, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
        this.secondPhaseRanking = this.compile(this.getSecondPhaseRanking(), queryProfiles, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
    }

    private void checkNameCollisions(Map<String, RankingExpressionFunction> functions, Map<String, Value> constants) {
        for (Map.Entry<String, RankingExpressionFunction> functionEntry : functions.entrySet()) {
            if (constants.get(functionEntry.getKey()) == null) continue;
            throw new IllegalArgumentException("Cannot have both a constant and function named '" + functionEntry.getKey() + "'");
        }
    }

    private Map<String, RankingExpressionFunction> getInlineFunctions() {
        return this.getFunctions().entrySet().stream().filter(x -> ((RankingExpressionFunction)x.getValue()).inline()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, RankingExpressionFunction> compileFunctions(Supplier<Map<String, RankingExpressionFunction>> functions, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, Map<String, RankingExpressionFunction> inlineFunctions, ExpressionTransforms expressionTransforms) {
        Map.Entry<String, RankingExpressionFunction> entry;
        LinkedHashMap<String, RankingExpressionFunction> compiledFunctions = new LinkedHashMap<String, RankingExpressionFunction>();
        while (null != (entry = this.findUncompiledFunction(functions.get(), compiledFunctions.keySet()))) {
            RankingExpressionFunction rankingExpressionFunction = entry.getValue();
            RankingExpression compiled = this.compile(rankingExpressionFunction.function().getBody(), queryProfiles, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
            compiledFunctions.put(entry.getKey(), rankingExpressionFunction.withExpression(compiled));
        }
        return compiledFunctions;
    }

    private Map.Entry<String, RankingExpressionFunction> findUncompiledFunction(Map<String, RankingExpressionFunction> functions, Set<String> compiledFunctionNames) {
        for (Map.Entry<String, RankingExpressionFunction> entry : functions.entrySet()) {
            if (compiledFunctionNames.contains(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private RankingExpression compile(RankingExpression expression, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, Map<String, Value> constants, Map<String, RankingExpressionFunction> inlineFunctions, ExpressionTransforms expressionTransforms) {
        if (expression == null) {
            return null;
        }
        RankProfileTransformContext context = new RankProfileTransformContext(this, queryProfiles, importedModels, constants, inlineFunctions);
        expression = expressionTransforms.transform(expression, context);
        for (Map.Entry<String, String> rankProperty : context.rankProperties().entrySet()) {
            this.addRankProperty(rankProperty.getKey(), rankProperty.getValue());
        }
        return expression;
    }

    public TypeContext<Reference> typeContext(QueryProfileRegistry queryProfiles) {
        MapEvaluationTypeContext context = new MapEvaluationTypeContext(this.getFunctions().values().stream().map(RankingExpressionFunction::function).collect(Collectors.toList()));
        this.getConstants().forEach((k, v) -> context.setType(FeatureNames.asConstantFeature(k), v.type()));
        this.rankingConstants().asMap().forEach((k, v) -> context.setType(FeatureNames.asConstantFeature(k), v.getTensorType()));
        this.allFields().forEach(field -> this.addAttributeFeatureTypes((ImmutableSDField)field, context));
        this.allImportedFields().forEach(field -> this.addAttributeFeatureTypes((ImmutableSDField)field, context));
        for (QueryProfileType queryProfileType : queryProfiles.getTypeRegistry().allComponents()) {
            for (FieldDescription field2 : queryProfileType.declaredFields().values()) {
                TensorType type = field2.getType().asTensorType();
                Optional feature = Reference.simple((String)field2.getName());
                if (!feature.isPresent() || !((Reference)feature.get()).name().equals("query")) continue;
                TensorType existingType = context.getType((Reference)feature.get());
                if (!Objects.equals(existingType, context.defaultTypeOf((Reference)feature.get()))) {
                    type = (TensorType)existingType.dimensionwiseGeneralizationWith(type).orElseThrow(() -> new IllegalArgumentException(queryProfileType + " contains query feature " + feature.get() + " with type " + field2.getType().asTensorType() + ", but this is already defined in another query profile with type " + context.getType((Reference)feature.get())));
                }
                context.setType((Reference)feature.get(), type);
            }
        }
        return context;
    }

    private void addAttributeFeatureTypes(ImmutableSDField field, MapEvaluationTypeContext context) {
        Attribute attribute = field.getAttribute();
        field.getAttributes().forEach((k, a) -> {
            String name = k;
            if (attribute == a) {
                name = field.getName();
            }
            context.setType(FeatureNames.asAttributeFeature(name), a.tensorType().orElse(TensorType.empty));
        });
    }

    public static class TypeSettings {
        private final Map<String, String> types = new HashMap<String, String>();

        public void addType(String name, String type) {
            this.types.put(name, type);
        }

        public Map<String, String> getTypes() {
            return Collections.unmodifiableMap(this.types);
        }
    }

    public static class MatchPhaseSettings {
        private String attribute = null;
        private boolean ascending = false;
        private int maxHits = 0;
        private double maxFilterCoverage = 0.2;
        private DiversitySettings diversity = null;
        private double evaluationPoint = 0.2;
        private double prePostFilterTippingPoint = 1.0;

        public void setDiversity(DiversitySettings value) {
            value.checkValid();
            this.diversity = value;
        }

        public void setAscending(boolean value) {
            this.ascending = value;
        }

        public void setAttribute(String value) {
            this.attribute = value;
        }

        public void setMaxHits(int value) {
            this.maxHits = value;
        }

        public void setMaxFilterCoverage(double value) {
            this.maxFilterCoverage = value;
        }

        public void setEvaluationPoint(double evaluationPoint) {
            this.evaluationPoint = evaluationPoint;
        }

        public void setPrePostFilterTippingPoint(double prePostFilterTippingPoint) {
            this.prePostFilterTippingPoint = prePostFilterTippingPoint;
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public int getMaxHits() {
            return this.maxHits;
        }

        public double getMaxFilterCoverage() {
            return this.maxFilterCoverage;
        }

        public DiversitySettings getDiversity() {
            return this.diversity;
        }

        public double getEvaluationPoint() {
            return this.evaluationPoint;
        }

        public double getPrePostFilterTippingPoint() {
            return this.prePostFilterTippingPoint;
        }

        public void checkValid() {
            if (this.attribute == null) {
                throw new IllegalArgumentException("match-phase did not set any attribute");
            }
            if (this.maxHits <= 0) {
                throw new IllegalArgumentException("match-phase did not set max-hits > 0");
            }
        }
    }

    public static final class DiversitySettings {
        private String attribute = null;
        private int minGroups = 0;
        private double cutoffFactor = 10.0;
        private Diversity.CutoffStrategy cutoffStrategy = Diversity.CutoffStrategy.loose;

        public void setAttribute(String value) {
            this.attribute = value;
        }

        public void setMinGroups(int value) {
            this.minGroups = value;
        }

        public void setCutoffFactor(double value) {
            this.cutoffFactor = value;
        }

        public void setCutoffStrategy(Diversity.CutoffStrategy strategy) {
            this.cutoffStrategy = strategy;
        }

        public void setCutoffStrategy(String strategy) {
            this.cutoffStrategy = Diversity.CutoffStrategy.valueOf((String)strategy);
        }

        public String getAttribute() {
            return this.attribute;
        }

        public int getMinGroups() {
            return this.minGroups;
        }

        public double getCutoffFactor() {
            return this.cutoffFactor;
        }

        public Diversity.CutoffStrategy getCutoffStrategy() {
            return this.cutoffStrategy;
        }

        public void checkValid() {
            if (this.attribute == null || this.attribute.isEmpty()) {
                throw new IllegalArgumentException("'diversity' did not set non-empty diversity attribute name.");
            }
            if (this.minGroups <= 0) {
                throw new IllegalArgumentException("'diversity' did not set min-groups > 0");
            }
            if (this.cutoffFactor < 1.0) {
                throw new IllegalArgumentException("diversity.cutoff.factor must be larger or equal to 1.0.");
            }
        }
    }

    public static class RankingExpressionFunction {
        private ExpressionFunction function;
        private final boolean inline;

        public RankingExpressionFunction(ExpressionFunction function, boolean inline) {
            this.function = function;
            this.inline = inline;
        }

        public void setReturnType(TensorType type) {
            this.function = this.function.withReturnType(type);
        }

        public ExpressionFunction function() {
            return this.function;
        }

        public boolean inline() {
            return this.inline && this.function.arguments().isEmpty();
        }

        public RankingExpressionFunction withExpression(RankingExpression expression) {
            return new RankingExpressionFunction(this.function.withBody(expression), this.inline);
        }

        public String toString() {
            return "function " + this.function;
        }
    }

    public static class RankProperty
    implements Serializable {
        private String name;
        private String value;

        public RankProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode() + 17 * this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RankProperty)) {
                return false;
            }
            RankProperty other = (RankProperty)object;
            return other.name.equals(this.name) && other.value.equals(this.value);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }
    }

    public static class RankSetting
    implements Serializable {
        private String fieldName;
        private Type type;
        private Object value;

        public RankSetting(String fieldName, Type type, Object value) {
            this.fieldName = fieldName;
            this.type = type;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public int getIntValue() {
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            return -1;
        }

        public int hashCode() {
            return this.fieldName.hashCode() + 17 * this.type.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RankSetting)) {
                return false;
            }
            RankSetting other = (RankSetting)object;
            return this.fieldName.equals(other.fieldName) && this.type.equals((Object)other.type);
        }

        public String toString() {
            return this.type + " setting " + this.fieldName + ": " + this.value;
        }

        public static enum Type {
            RANKTYPE("rank-type"),
            LITERALBOOST("literal-boost"),
            WEIGHT("weight"),
            PREFERBITVECTOR("preferbitvector", true);

            private String name;
            private boolean isIndexLevel;

            private Type(String name) {
                this(name, false);
            }

            private Type(String name, boolean isIndexLevel) {
                this.name = name;
                this.isIndexLevel = isIndexLevel;
            }

            public boolean isIndexLevel() {
                return this.isIndexLevel;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return "type: " + this.name;
            }
        }
    }
}

