/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.content.Distributor;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StorageGroup {
    private final boolean useCpuSocketAffinity;
    private final String index;
    private Optional<String> partitions;
    String name;
    private final ContentCluster owner;
    private final Optional<Long> mmapNoCoreLimit;
    private final Optional<Boolean> coreOnOOM;
    private final Optional<String> noVespaMalloc;
    private final Optional<String> vespaMalloc;
    private final Optional<String> vespaMallocDebug;
    private final Optional<String> vespaMallocDebugStackTrace;
    private final List<StorageGroup> subgroups = new ArrayList<StorageGroup>();
    private final List<StorageNode> nodes = new ArrayList<StorageNode>();

    private StorageGroup(ContentCluster owner, String name, String index, Optional<String> partitions, boolean useCpuSocketAffinity, Optional<Long> mmapNoCoreLimit, Optional<Boolean> coreOnOOM, Optional<String> noVespaMalloc, Optional<String> vespaMalloc, Optional<String> vespaMallocDebug, Optional<String> vespaMallocDebugStackTrace) {
        this.owner = owner;
        this.index = index;
        this.name = name;
        this.partitions = partitions;
        this.useCpuSocketAffinity = useCpuSocketAffinity;
        this.mmapNoCoreLimit = mmapNoCoreLimit;
        this.coreOnOOM = coreOnOOM;
        this.noVespaMalloc = noVespaMalloc;
        this.vespaMalloc = vespaMalloc;
        this.vespaMallocDebug = vespaMallocDebug;
        this.vespaMallocDebugStackTrace = vespaMallocDebugStackTrace;
    }

    private StorageGroup(ContentCluster owner, String name, String index) {
        this(owner, name, index, Optional.empty(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public String getName() {
        return this.name;
    }

    public List<StorageGroup> getSubgroups() {
        return this.subgroups;
    }

    public List<StorageNode> getNodes() {
        return this.nodes;
    }

    public ContentCluster getOwner() {
        return this.owner;
    }

    public String getIndex() {
        return this.index;
    }

    public Optional<String> getPartitions() {
        return this.partitions;
    }

    public boolean useCpuSocketAffinity() {
        return this.useCpuSocketAffinity;
    }

    public Optional<Long> getMmapNoCoreLimit() {
        return this.mmapNoCoreLimit;
    }

    public Optional<Boolean> getCoreOnOOM() {
        return this.coreOnOOM;
    }

    public Optional<String> getNoVespaMalloc() {
        return this.noVespaMalloc;
    }

    public Optional<String> getVespaMalloc() {
        return this.vespaMalloc;
    }

    public Optional<String> getVespaMallocDebug() {
        return this.vespaMallocDebug;
    }

    public Optional<String> getVespaMallocDebugStackTrace() {
        return this.vespaMallocDebugStackTrace;
    }

    public List<StorageNode> recursiveGetNodes() {
        if (!this.nodes.isEmpty()) {
            return this.nodes;
        }
        ArrayList<StorageNode> nodes = new ArrayList<StorageNode>();
        for (StorageGroup subgroup : this.subgroups) {
            nodes.addAll(subgroup.recursiveGetNodes());
        }
        return nodes;
    }

    public Collection<StorDistributionConfig.Group.Builder> getGroupStructureConfig() {
        ArrayList<StorDistributionConfig.Group.Builder> groups = new ArrayList<StorDistributionConfig.Group.Builder>();
        StorDistributionConfig.Group.Builder myGroup = new StorDistributionConfig.Group.Builder();
        this.getConfig(myGroup);
        groups.add(myGroup);
        for (StorageGroup g : this.subgroups) {
            groups.addAll(g.getGroupStructureConfig());
        }
        return groups;
    }

    public void getConfig(StorDistributionConfig.Group.Builder builder) {
        builder.index(this.index == null ? "invalid" : this.index);
        builder.name(this.name == null ? "invalid" : this.name);
        if (this.partitions.isPresent()) {
            builder.partitions(this.partitions.get());
        }
        for (StorageNode node : this.nodes) {
            StorDistributionConfig.Group.Nodes.Builder nb = new StorDistributionConfig.Group.Nodes.Builder();
            nb.index(node.getDistributionKey());
            nb.retired(node.isRetired());
            builder.nodes.add(nb);
        }
        builder.capacity(this.getCapacity());
    }

    public int getNumberOfLeafGroups() {
        int count = this.subgroups.isEmpty() ? 1 : 0;
        for (StorageGroup g : this.subgroups) {
            count += g.getNumberOfLeafGroups();
        }
        return count;
    }

    public double getCapacity() {
        double capacity = 0.0;
        for (StorageNode node : this.nodes) {
            capacity += node.getCapacity();
        }
        for (StorageGroup group : this.subgroups) {
            capacity += group.getCapacity();
        }
        return capacity;
    }

    public int countNodes() {
        int nodeCount = this.nodes.size();
        for (StorageGroup group : this.subgroups) {
            nodeCount += group.countNodes();
        }
        return nodeCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageGroup) {
            StorageGroup rhs = (StorageGroup)obj;
            return this.index.equals(rhs.index) && this.name.equals(rhs.name) && this.partitions.equals(rhs.partitions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.partitions);
    }

    public static Map<HostResource, ClusterMembership> provisionHosts(NodesSpecification nodesSpecification, String clusterIdString, HostSystem hostSystem, DeployLogger logger) {
        ClusterSpec.Id clusterId = ClusterSpec.Id.from((String)clusterIdString);
        return nodesSpecification.provision(hostSystem, ClusterSpec.Type.content, clusterId, logger);
    }

    public static class Builder {
        private final ModelElement clusterElement;
        private final ContentCluster owner;
        private final ConfigModelContext context;

        public Builder(ModelElement clusterElement, ContentCluster owner, ConfigModelContext context) {
            this.clusterElement = clusterElement;
            this.owner = owner;
            this.context = context;
        }

        public StorageGroup buildRootGroup(DeployState deployState) {
            Optional<ModelElement> group = Optional.ofNullable(this.clusterElement.getChild("group"));
            Optional<ModelElement> nodes = this.getNodes(this.clusterElement);
            if (group.isPresent() && nodes.isPresent()) {
                throw new IllegalStateException("Both group and nodes exists, only one of these tags is legal");
            }
            if (group.isPresent() && (group.get().getStringAttribute("name") != null || group.get().getIntegerAttribute("distribution-key") != null)) {
                deployState.getDeployLogger().log(LogLevel.INFO, "'distribution-key' attribute on a content cluster's root group is ignored");
            }
            GroupBuilder groupBuilder = this.collectGroup(group, nodes, null, null);
            if (this.owner.isHostedVespa()) {
                return groupBuilder.buildHosted(deployState, this.owner, Optional.empty());
            }
            return groupBuilder.buildNonHosted(deployState, this.owner, Optional.empty());
        }

        private GroupBuilder collectGroup(Optional<ModelElement> groupElement, Optional<ModelElement> nodesElement, String name, String index) {
            StorageGroup group = new StorageGroup(this.owner, name, index, this.childAsString(groupElement, "distribution.partitions"), this.booleanAttributeOr(groupElement, "cpu-socket-affinity", false), this.childAsLong(groupElement, "mmap-core-limit"), this.childAsBoolean(groupElement, "core-on-oom"), this.childAsString(groupElement, "no-vespamalloc"), this.childAsString(groupElement, "vespamalloc"), this.childAsString(groupElement, "vespamalloc-debug"), this.childAsString(groupElement, "vespamalloc-debug-stacktrace"));
            List<GroupBuilder> subGroups = groupElement.isPresent() ? this.collectSubGroups(group, groupElement.get()) : Collections.emptyList();
            ArrayList<XmlNodeBuilder> explicitNodes = new ArrayList<XmlNodeBuilder>();
            explicitNodes.addAll(this.collectExplicitNodes(groupElement));
            explicitNodes.addAll(this.collectExplicitNodes(nodesElement));
            if (subGroups.size() > 0 && nodesElement.isPresent()) {
                throw new IllegalArgumentException("A group can contain either explicit subgroups or a nodes specification, but not both.");
            }
            Optional<NodesSpecification> nodeRequirement = nodesElement.isPresent() && nodesElement.get().getStringAttribute("count") != null ? Optional.of(NodesSpecification.from(nodesElement.get(), this.context)) : (!nodesElement.isPresent() && subGroups.isEmpty() && this.context.getDeployState().isHosted() ? Optional.of(NodesSpecification.nonDedicated(1, this.context)) : Optional.empty());
            return new GroupBuilder(group, subGroups, explicitNodes, nodeRequirement, this.context.getDeployLogger());
        }

        private Optional<String> childAsString(Optional<ModelElement> element, String childTagName) {
            if (!element.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(element.get().childAsString(childTagName));
        }

        private Optional<Long> childAsLong(Optional<ModelElement> element, String childTagName) {
            if (!element.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(element.get().childAsLong(childTagName));
        }

        private Optional<Boolean> childAsBoolean(Optional<ModelElement> element, String childTagName) {
            if (!element.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(element.get().childAsBoolean(childTagName));
        }

        private boolean booleanAttributeOr(Optional<ModelElement> element, String attributeName, boolean defaultValue) {
            if (!element.isPresent()) {
                return defaultValue;
            }
            return element.get().getBooleanAttribute(attributeName, defaultValue);
        }

        private Optional<ModelElement> getNodes(ModelElement groupOrNodesElement) {
            if (groupOrNodesElement.getXml().getTagName().equals("nodes")) {
                return Optional.of(groupOrNodesElement);
            }
            return Optional.ofNullable(groupOrNodesElement.getChild("nodes"));
        }

        private List<XmlNodeBuilder> collectExplicitNodes(Optional<ModelElement> groupOrNodesElement) {
            if (!groupOrNodesElement.isPresent()) {
                return Collections.emptyList();
            }
            ArrayList<XmlNodeBuilder> nodes = new ArrayList<XmlNodeBuilder>();
            for (ModelElement n : groupOrNodesElement.get().subElements("node")) {
                nodes.add(new XmlNodeBuilder(this.clusterElement, n));
            }
            return nodes;
        }

        private List<GroupBuilder> collectSubGroups(StorageGroup parentGroup, ModelElement parentGroupElement) {
            List<ModelElement> subGroupElements = parentGroupElement.subElements("group");
            if (subGroupElements.size() > 1 && !parentGroup.getPartitions().isPresent()) {
                throw new IllegalArgumentException("'distribution' attribute is required with multiple subgroups");
            }
            ArrayList<GroupBuilder> subGroups = new ArrayList<GroupBuilder>();
            Object indexPrefix = "";
            if (parentGroup.index != null) {
                indexPrefix = parentGroup.index + ".";
            }
            for (ModelElement g : subGroupElements) {
                subGroups.add(this.collectGroup(Optional.of(g), Optional.ofNullable(g.getChild("nodes")), g.getStringAttribute("name"), (String)indexPrefix + g.getIntegerAttribute("distribution-key")));
            }
            return subGroups;
        }

        private static StorageNode createStorageNode(DeployState deployState, ContentCluster parent, HostResource hostResource, StorageGroup parentGroup, ClusterMembership clusterMembership) {
            StorageNode sNode = new StorageNode(parent.getStorageNodes(), null, clusterMembership.index(), clusterMembership.retired());
            sNode.setHostResource(hostResource);
            sNode.initService(deployState.getDeployLogger());
            PersistenceEngine provider = parent.getPersistence().create(deployState, sNode, parentGroup, null);
            Distributor d = new Distributor(parent.getDistributorNodes(), clusterMembership.index(), null, provider);
            d.setHostResource(sNode.getHostResource());
            d.initService(deployState.getDeployLogger());
            return sNode;
        }

        private static class XmlNodeBuilder {
            private final ModelElement clusterElement;
            private final ModelElement element;

            private XmlNodeBuilder(ModelElement clusterElement, ModelElement element) {
                this.clusterElement = clusterElement;
                this.element = element;
            }

            public StorageNode build(DeployState deployState, ContentCluster parent, StorageGroup storageGroup) {
                StorageNode sNode = (StorageNode)new StorageNode.Builder().build(deployState, parent.getStorageNodes(), this.element.getXml());
                PersistenceEngine provider = parent.getPersistence().create(deployState, sNode, storageGroup, this.element);
                new Distributor.Builder(this.clusterElement, provider).build(deployState, parent.getDistributorNodes(), this.element.getXml());
                return sNode;
            }
        }

        private static class GroupBuilder {
            private final StorageGroup storageGroup;
            private final List<GroupBuilder> subGroups;
            private final List<XmlNodeBuilder> nodeBuilders;
            private final Optional<NodesSpecification> nodeRequirement;
            private final DeployLogger deployLogger;

            private GroupBuilder(StorageGroup storageGroup, List<GroupBuilder> subGroups, List<XmlNodeBuilder> nodeBuilders, Optional<NodesSpecification> nodeRequirement, DeployLogger deployLogger) {
                this.storageGroup = storageGroup;
                this.subGroups = subGroups;
                this.nodeBuilders = nodeBuilders;
                this.nodeRequirement = nodeRequirement;
                this.deployLogger = deployLogger;
            }

            public StorageGroup buildNonHosted(DeployState deployState, ContentCluster owner, Optional<GroupBuilder> parent) {
                for (GroupBuilder subGroup : this.subGroups) {
                    this.storageGroup.subgroups.add(subGroup.buildNonHosted(deployState, owner, Optional.of(this)));
                }
                for (XmlNodeBuilder nodeBuilder : this.nodeBuilders) {
                    this.storageGroup.nodes.add(nodeBuilder.build(deployState, owner, this.storageGroup));
                }
                if (!parent.isPresent() && this.subGroups.isEmpty() && this.nodeBuilders.isEmpty()) {
                    this.storageGroup.nodes.add(this.buildSingleNode(deployState, owner));
                }
                if (!parent.isPresent()) {
                    owner.redundancy().setTotalNodes(this.storageGroup.countNodes());
                }
                return this.storageGroup;
            }

            private StorageNode buildSingleNode(DeployState deployState, ContentCluster parent) {
                int distributionKey = 0;
                StorageNode sNode = new StorageNode(parent.getStorageNodes(), 1.0, distributionKey, false);
                sNode.setHostResource(parent.getHostSystem().getHost("default_singlenode_container"));
                PersistenceEngine provider = parent.getPersistence().create(deployState, sNode, this.storageGroup, null);
                new Distributor(parent.getDistributorNodes(), distributionKey, null, provider);
                return sNode;
            }

            public StorageGroup buildHosted(DeployState deployState, ContentCluster owner, Optional<GroupBuilder> parent) {
                if (this.storageGroup.getIndex() != null) {
                    throw new IllegalArgumentException("Specifying individual groups is not supported on hosted applications");
                }
                Map<HostResource, ClusterMembership> hostMapping = this.nodeRequirement.isPresent() ? StorageGroup.provisionHosts(this.nodeRequirement.get(), owner.getStorageNodes().getClusterName(), owner.getRoot().getHostSystem(), this.deployLogger) : Collections.emptyMap();
                Map<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostGroups = this.collectAllocatedSubgroups(hostMapping);
                if (hostGroups.size() > 1) {
                    if (parent.isPresent()) {
                        throw new IllegalArgumentException("Cannot specify groups using the groups attribute in nested content groups");
                    }
                    owner.redundancy().setTotalNodes(hostMapping.size());
                    owner.redundancy().setImplicitGroups(hostGroups.size());
                    int redundancyPerGroup = (int)Math.floor(owner.redundancy().effectiveFinalRedundancy() / hostGroups.size());
                    this.storageGroup.partitions = Optional.of(this.computePartitions(redundancyPerGroup, hostGroups.size()));
                    for (Map.Entry<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostGroup : hostGroups.entrySet()) {
                        String groupIndex = String.valueOf(hostGroup.getKey().get().index());
                        StorageGroup subgroup = new StorageGroup(owner, groupIndex, groupIndex);
                        for (Map.Entry<HostResource, ClusterMembership> host : hostGroup.getValue().entrySet()) {
                            subgroup.nodes.add(Builder.createStorageNode(deployState, owner, host.getKey(), subgroup, host.getValue()));
                        }
                        this.storageGroup.subgroups.add(subgroup);
                    }
                } else {
                    for (Map.Entry<HostResource, ClusterMembership> host : hostMapping.entrySet()) {
                        this.storageGroup.nodes.add(Builder.createStorageNode(deployState, owner, host.getKey(), this.storageGroup, host.getValue()));
                    }
                    for (GroupBuilder subGroup : this.subGroups) {
                        this.storageGroup.subgroups.add(subGroup.buildHosted(deployState, owner, Optional.of(this)));
                    }
                    if (!parent.isPresent()) {
                        owner.redundancy().setTotalNodes(this.storageGroup.countNodes());
                    }
                }
                return this.storageGroup;
            }

            private String computePartitions(int redundancyPerGroup, int numGroups) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < numGroups - 1; ++i) {
                    sb.append(redundancyPerGroup);
                    sb.append("|");
                }
                sb.append("*");
                return sb.toString();
            }

            private Map<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> collectAllocatedSubgroups(Map<HostResource, ClusterMembership> hostMapping) {
                LinkedHashMap<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>> hostsPerGroup = new LinkedHashMap<Optional<ClusterSpec.Group>, Map<HostResource, ClusterMembership>>();
                for (Map.Entry<HostResource, ClusterMembership> entry : hostMapping.entrySet()) {
                    Optional group = entry.getValue().cluster().group();
                    LinkedHashMap<HostResource, ClusterMembership> hostsInGroup = (LinkedHashMap<HostResource, ClusterMembership>)hostsPerGroup.get(group);
                    if (hostsInGroup == null) {
                        hostsInGroup = new LinkedHashMap<HostResource, ClusterMembership>();
                        hostsPerGroup.put(group, hostsInGroup);
                    }
                    hostsInGroup.put(entry.getKey(), entry.getValue());
                }
                return hostsPerGroup;
            }
        }
    }
}

