/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private HostName loadBalancerName = null;
    private URI ztsUrl = null;
    private String athenzDnsSuffix = null;
    private boolean hostedVespa = false;
    private Zone zone;
    private Set<Rotation> rotations;
    private boolean isBootstrap = false;
    private boolean isFirstTimeDeployment = false;
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useFdispatchByDefault = true;
    private boolean useAdaptiveDispatch = false;
    private boolean useSeparateServiceTypeForLogserverContainer = false;

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return this.loadBalancerName;
    }

    public URI ztsUrl() {
        return this.ztsUrl;
    }

    public String athenzDnsSuffix() {
        return this.athenzDnsSuffix;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<Rotation> rotations() {
        return this.rotations;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public boolean isFirstTimeDeployment() {
        return this.isFirstTimeDeployment;
    }

    public boolean useAdaptiveDispatch() {
        return this.useAdaptiveDispatch;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public boolean useFdispatchByDefault() {
        return this.useFdispatchByDefault;
    }

    public boolean useSeparateServiceTypeForLogserverContainer() {
        return this.useSeparateServiceTypeForLogserverContainer;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setUseAdaptiveDispatch(boolean useAdaptiveDispatch) {
        this.useAdaptiveDispatch = useAdaptiveDispatch;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setUseSeparateServiceTypeForLogserverContainer(boolean useSeparateServiceTypeForLogserverContainer) {
        this.useSeparateServiceTypeForLogserverContainer = useSeparateServiceTypeForLogserverContainer;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int httpPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.httpPort == other.getHttpPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int httpPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.httpPort = httpPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

