/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexingValues
extends Processor {
    public IndexingValues(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (Field field : this.search.getDocument().fieldSet()) {
            SDField sdField = (SDField)field;
            if (sdField.isExtraField()) continue;
            new RequireThatDocumentFieldsAreImmutable(field).convert((Expression)sdField.getIndexingScript());
        }
    }

    private class RequireThatDocumentFieldsAreImmutable
    extends ExpressionConverter {
        final Field field;
        Expression mutatedBy;

        RequireThatDocumentFieldsAreImmutable(Field field) {
            this.field = field;
        }

        public ExpressionConverter branch() {
            return this.clone();
        }

        protected boolean shouldConvert(Expression exp) {
            if (exp instanceof OutputExpression && this.mutatedBy != null) {
                throw IndexingValues.this.newProcessException(IndexingValues.this.search, this.field, "Indexing expression '" + this.mutatedBy + "' modifies the value of the document field '" + this.field.getName() + "'. This is no longer supported -- declare such fields outside the document.");
            }
            if (exp instanceof InputExpression && ((InputExpression)exp).getFieldName().equals(this.field.getName())) {
                this.mutatedBy = null;
            } else if (exp.createdOutputType() != null) {
                this.mutatedBy = exp;
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            throw new UnsupportedOperationException();
        }
    }
}

