/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import org.w3c.dom.Element;

public class DomComponentBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Component> {
    public static final String elementName = "component";
    private final ComponentId namespace;

    public DomComponentBuilder() {
        this(null);
    }

    public DomComponentBuilder(ComponentId namespace) {
        this.namespace = namespace;
    }

    @Override
    protected Component doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element spec) {
        Component component = this.buildComponent(spec);
        DomComponentBuilder.addChildren(deployState, ancestor, spec, component);
        return component;
    }

    private Component buildComponent(Element spec) {
        BundleInstantiationSpecification bundleSpec = BundleInstantiationSpecificationBuilder.build(spec).nestInNamespace(this.namespace);
        return new Component(new ComponentModel(bundleSpec));
    }

    public static void addChildren(DeployState deployState, AbstractConfigProducer ancestor, Element componentNode, Component<? super Component<?, ?>, ?> component) {
        for (Element childNode : XML.getChildren((Element)componentNode, (String)elementName)) {
            DomComponentBuilder.addAndInjectChild(deployState, ancestor, component, childNode);
        }
    }

    private static void addAndInjectChild(DeployState deployState, AbstractConfigProducer ancestor, Component<? super Component<?, ?>, ?> component, Element childNode) {
        Component child = (Component)new DomComponentBuilder(component.getComponentId()).build(deployState, ancestor, childNode);
        component.addComponent(child);
        component.inject(child);
    }
}

