/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourcesReductionValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        for (ClusterSpec.Id clusterId : current.allClusters()) {
            Capacity currentCapacity = (Capacity)current.provisioned().all().get(clusterId);
            Capacity nextCapacity = (Capacity)next.provisioned().all().get(clusterId);
            if (currentCapacity == null || nextCapacity == null) continue;
            this.validate(currentCapacity, nextCapacity, clusterId, overrides, now);
        }
        return List.of();
    }

    private void validate(Capacity current, Capacity next, ClusterSpec.Id clusterId, ValidationOverrides overrides, Instant now) {
        if (current.minResources().nodeResources() == NodeResources.unspecified) {
            return;
        }
        if (next.minResources().nodeResources() == NodeResources.unspecified) {
            return;
        }
        List illegalChanges = Stream.of(ResourcesReductionValidator.validateResource("vCPU", current.minResources().nodeResources().vcpu(), next.minResources().nodeResources().vcpu()), ResourcesReductionValidator.validateResource("memory GB", current.minResources().nodeResources().memoryGb(), next.minResources().nodeResources().memoryGb()), ResourcesReductionValidator.validateResource("disk GB", current.minResources().nodeResources().diskGb(), next.minResources().nodeResources().diskGb())).flatMap(Optional::stream).collect(Collectors.toList());
        if (illegalChanges.isEmpty()) {
            return;
        }
        overrides.invalid(ValidationId.resourcesReduction, "Resource reduction in '" + clusterId.value() + "' is too large. " + String.join((CharSequence)" ", illegalChanges) + " New min resources must be at least 50% of the current min resources", now);
    }

    private static Optional<String> validateResource(String resourceName, double currentValue, double nextValue) {
        if (nextValue >= currentValue * 0.5 || nextValue >= currentValue - 1.0) {
            return Optional.empty();
        }
        return Optional.of(String.format(Locale.ENGLISH, "Current %s: %.2f, new: %.2f.", resourceName, currentValue, nextValue));
    }
}

