/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.admin.AdminModel;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.vespa.model.builder.xml.dom.DomClientsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomRoutingBuilder;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.generic.GenericServicesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class VespaConfigModelRegistry
extends ConfigModelRegistry {
    private final List<ConfigModelBuilder> builderList = new ArrayList<ConfigModelBuilder>();

    public VespaConfigModelRegistry(ConfigModelRegistry chained) {
        super(chained);
        this.builderList.add(new AdminModel.BuilderV2());
        this.builderList.add(new AdminModel.BuilderV4());
        this.builderList.add(new DomRoutingBuilder());
        this.builderList.add(new DomClientsBuilder());
        this.builderList.add(new Content.Builder());
        this.builderList.add(new ContainerModelBuilder(false, ContainerModelBuilder.Networking.enable));
        this.builderList.add(new GenericServicesBuilder());
    }

    @Override
    public Collection<ConfigModelBuilder> resolve(ConfigModelId id) {
        HashSet<ConfigModelBuilder> builders = new HashSet<ConfigModelBuilder>(this.chained().resolve(id));
        for (ConfigModelBuilder builder : this.builderList) {
            if (!builder.handlesElements().contains(id)) continue;
            builders.add(builder);
        }
        return builders;
    }
}

