/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.google.common.collect.ImmutableList;
import com.yahoo.component.Version;
import com.yahoo.config.provision.Flavor;
import java.util.List;
import java.util.Optional;

public class Host {
    private final String hostname;
    private final ImmutableList<String> aliases;
    private final Optional<Flavor> flavor;
    private final Optional<Version> version;

    public Host(String hostname) {
        this(hostname, (List<String>)ImmutableList.of(), Optional.empty());
    }

    public Host(String hostname, List<String> hostAliases) {
        this(hostname, hostAliases, Optional.empty());
    }

    public Host(String hostname, List<String> hostAliases, Optional<Flavor> flavor) {
        this(hostname, hostAliases, flavor, Optional.empty());
    }

    public Host(String hostname, List<String> hostAliases, Optional<Flavor> flavor, Optional<Version> version) {
        this.hostname = hostname;
        this.aliases = ImmutableList.copyOf(hostAliases);
        this.flavor = flavor;
        this.version = version;
    }

    public String hostname() {
        return this.hostname;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public Optional<Flavor> flavor() {
        return this.flavor;
    }

    public Optional<Version> version() {
        return this.version;
    }

    public String toString() {
        return this.hostname + (String)(this.aliases.size() > 0 ? " (aliases: " + this.aliases + ")" : "") + (String)(this.flavor.isPresent() ? " (flavor: " + this.flavor.get() + ")" : "");
    }
}

