/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Binding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.container.http.xml.FilterChainsBuilder;
import com.yahoo.vespa.model.container.http.xml.JettyHttpServerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class HttpBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Http> {
    @Override
    protected Http doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element spec) {
        FilterChains filterChains;
        List<Binding> bindings = new ArrayList<Binding>();
        AccessControl accessControl = null;
        Element filteringElem = XML.getChild((Element)spec, (String)"filtering");
        if (filteringElem != null) {
            filterChains = (FilterChains)new FilterChainsBuilder().build(deployState, ancestor, filteringElem);
            bindings = this.readFilterBindings(filteringElem, deployState.getDeployLogger());
            Element accessControlElem = XML.getChild((Element)filteringElem, (String)"access-control");
            if (accessControlElem != null) {
                accessControl = this.buildAccessControl(deployState, ancestor, accessControlElem);
                bindings.addAll(accessControl.getBindings());
                filterChains.add(new Chain(FilterChains.emptyChainSpec(AccessControl.ACCESS_CONTROL_CHAIN_ID)));
            }
        } else {
            filterChains = new FilterChainsBuilder().newChainsInstance(ancestor);
        }
        Http http = new Http(bindings, accessControl);
        http.setFilterChains(filterChains);
        this.buildHttpServers(deployState, ancestor, http, spec);
        return http;
    }

    private AccessControl buildAccessControl(DeployState deployState, AbstractConfigProducer ancestor, Element accessControlElem) {
        AthenzDomain domain = HttpBuilder.getAccessControlDomain(deployState, accessControlElem);
        AccessControl.Builder builder = new AccessControl.Builder(domain.value(), deployState.getDeployLogger());
        HttpBuilder.getContainerCluster(ancestor).ifPresent(builder::setHandlers);
        XmlHelper.getOptionalAttribute(accessControlElem, "read").ifPresent(readAttr -> builder.readEnabled(Boolean.valueOf(readAttr)));
        XmlHelper.getOptionalAttribute(accessControlElem, "write").ifPresent(writeAttr -> builder.writeEnabled(Boolean.valueOf(writeAttr)));
        Element excludeElem = XML.getChild((Element)accessControlElem, (String)"exclude");
        if (excludeElem != null) {
            XML.getChildren((Element)excludeElem, (String)"binding").stream().map(XML::getValue).forEach(builder::excludeBinding);
        }
        return builder.build();
    }

    private static AthenzDomain getAccessControlDomain(DeployState deployState, Element accessControlElem) {
        AthenzDomain tenantDomain = deployState.getProperties().athenzDomain().orElse(null);
        AthenzDomain explicitDomain = XmlHelper.getOptionalAttribute(accessControlElem, "domain").map(AthenzDomain::from).orElse(null);
        if (tenantDomain == null) {
            if (explicitDomain == null) {
                throw new IllegalStateException("No Athenz domain provided for 'access-control'");
            }
            deployState.getDeployLogger().log(Level.WARNING, "Athenz tenant is not provided by deploy call. This will soon be handled as failure.");
        }
        if (explicitDomain != null) {
            if (tenantDomain != null && !explicitDomain.equals((Object)tenantDomain)) {
                throw new IllegalArgumentException(String.format("Domain in access-control ('%s') does not match tenant domain ('%s')", explicitDomain.value(), tenantDomain.value()));
            }
            deployState.getDeployLogger().log(Level.WARNING, "Domain in 'access-control' is deprecated and will be removed soon");
        }
        return tenantDomain != null ? tenantDomain : explicitDomain;
    }

    private static Optional<ApplicationContainerCluster> getContainerCluster(AbstractConfigProducer configProducer) {
        AbstractConfigProducer currentProducer = configProducer;
        while (!ApplicationContainerCluster.class.isAssignableFrom(currentProducer.getClass())) {
            if ((currentProducer = currentProducer.getParent()) != null) continue;
            return Optional.empty();
        }
        return Optional.of((ApplicationContainerCluster)currentProducer);
    }

    private List<Binding> readFilterBindings(Element filteringSpec, DeployLogger logger) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        for (Element child : XML.getChildren((Element)filteringSpec)) {
            String tagName = child.getTagName();
            if (!tagName.equals("request-chain") && !tagName.equals("response-chain")) continue;
            ComponentSpecification chainId = XmlHelper.getIdRef(child);
            for (Element bindingSpec : XML.getChildren((Element)child, (String)"binding")) {
                String binding = XML.getValue((Element)bindingSpec);
                result.add(Binding.create(chainId, binding, logger));
            }
        }
        return result;
    }

    private void buildHttpServers(DeployState deployState, AbstractConfigProducer ancestor, Http http, Element spec) {
        http.setHttpServer((JettyHttpServer)new JettyHttpServerBuilder().build(deployState, ancestor, spec));
    }

    static int readPort(ModelElement spec, boolean isHosted, DeployLogger logger) {
        Integer port = spec.integerAttribute("port");
        if (port == null) {
            return Defaults.getDefaults().vespaWebServicePort();
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        int legalPortInHostedVespa = Container.BASEPORT;
        if (isHosted && port != legalPortInHostedVespa && !spec.booleanAttribute("required", false)) {
            throw new IllegalArgumentException("Illegal port " + port + " in http server '" + spec.stringAttribute("id") + "': Port must be set to " + legalPortInHostedVespa);
        }
        return port;
    }
}

