/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.SearchBuilder;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.search.SearchDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchDocumentModel {
    private final DocumentModel documentModel;
    private final List<SearchDefinition> searchDefinitions;

    public SearchDocumentModel(DocumentModel documentModel, List<SearchDefinition> searchDefinitions) {
        this.documentModel = documentModel;
        this.searchDefinitions = searchDefinitions;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public List<SearchDefinition> getSearchDefinitions() {
        return this.searchDefinitions;
    }

    public static SearchDocumentModel fromBuilderAndNames(SearchBuilder builder, Map<String, String> names) {
        ArrayList<SearchDefinition> ret = new ArrayList<SearchDefinition>();
        for (Search search : builder.getSearchList()) {
            ret.add(new SearchDefinition(names.get(search.getName()), search));
        }
        return new SearchDocumentModel(builder.getModel(), ret);
    }

    public static SearchDocumentModel fromBuilder(SearchBuilder builder) {
        ArrayList<SearchDefinition> ret = new ArrayList<SearchDefinition>();
        for (Search search : builder.getSearchList()) {
            ret.add(new SearchDefinition(search.getName(), search));
        }
        return new SearchDocumentModel(builder.getModel(), ret);
    }
}

