/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.builder.xml;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.log.LogLevel;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlHelper {
    private static final Logger log = Logger.getLogger(XmlHelper.class.getPackage().toString());
    private static final String idReference = "idref";
    public static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    private XmlHelper() {
    }

    public static String nullIfEmpty(String attribute) {
        if (attribute.isEmpty()) {
            return null;
        }
        return attribute;
    }

    public static String getIdString(Element element) {
        String idString = element.getAttribute("id");
        if (idString == null || idString.trim().equals("")) {
            idString = element.getAttribute(idReference);
        }
        if (idString == null || idString.trim().equals("")) {
            idString = element.getAttribute("ident");
        }
        return idString;
    }

    public static ComponentId getId(Element element) {
        return new ComponentId(XmlHelper.getIdString(element));
    }

    public static ComponentSpecification getIdRef(Element element) {
        return new ComponentSpecification(XmlHelper.getIdString(element));
    }

    public static Document getDocument(Reader reader) {
        Document doc;
        try {
            doc = XmlHelper.getDocumentBuilder().parse(new InputSource(reader));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
        return doc;
    }

    public static List<String> splitAndDiscardEmpty(String field, String regex) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String t : field.split(regex)) {
            if (t.isEmpty()) continue;
            ret.add(t);
        }
        return ret;
    }

    public static List<String> spaceSeparatedSymbols(String field) {
        return XmlHelper.splitAndDiscardEmpty(field, " ");
    }

    public static Collection<String> spaceSeparatedSymbolsFromAttribute(Element spec, String name) {
        return XmlHelper.spaceSeparatedSymbols(spec.getAttribute(name));
    }

    public static Collection<String> valuesFromElements(Element parent, String elementName) {
        ArrayList<String> symbols = new ArrayList<String>();
        for (Element symbol : XML.getChildren((Element)parent, (String)elementName)) {
            symbols.add(XML.getValue((Element)symbol).trim());
        }
        return symbols;
    }

    public static boolean isReference(Element element) {
        return element.hasAttribute(idReference);
    }

    public static synchronized DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            log.log((Level)LogLevel.DEBUG, "XML parser now operational!");
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            log.log(LogLevel.WARNING, "No XML parser available - " + e);
            return null;
        }
    }

    public static Optional<String> getOptionalAttribute(Element element, String name) {
        return Optional.ofNullable(element.getAttribute(name)).filter(s -> !s.isEmpty());
    }

    public static Optional<String> getOptionalChildValue(Element parent, String childName) {
        Element child = XML.getChild((Element)parent, (String)childName);
        if (child == null) {
            return Optional.empty();
        }
        if (child.getFirstChild() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(child.getFirstChild().getNodeValue());
    }

    static {
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
    }
}

