/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import java.util.Map;

public class NoPrefixForIndexes
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        for (AbstractSearchCluster cluster : model.getSearchClusters()) {
            if (!(cluster instanceof IndexedSearchCluster)) continue;
            IndexedSearchCluster sc = (IndexedSearchCluster)cluster;
            for (DocumentDatabase docDb : sc.getDocumentDbs()) {
                DerivedConfiguration sdConfig = docDb.getDerivedConfiguration();
                Search search = sdConfig.getSearch();
                for (SDField field : search.allConcreteFields()) {
                    if (!field.doesIndexing()) continue;
                    if (field.getMatching().getAlgorithm().equals((Object)Matching.Algorithm.PREFIX)) {
                        this.failField(search, field);
                    }
                    for (Map.Entry<String, Index> e : field.getIndices().entrySet()) {
                        if (!e.getValue().isPrefix()) continue;
                        this.failField(search, field);
                    }
                }
            }
        }
    }

    private void failField(Search search, SDField field) {
        throw new IllegalArgumentException("For search '" + search.getName() + "', field '" + field.getName() + "': match/index:prefix is not supported for indexes.");
    }
}

