/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ssl.LegacySslProvider;
import org.w3c.dom.Element;

public class ConnectorFactory
extends SimpleComponent
implements ConnectorConfig.Producer {
    private final String name;
    private final int listenPort;
    private final Element legacyConfig;
    private final SimpleComponent sslProviderComponent;

    public ConnectorFactory(String name, int listenPort) {
        this(name, listenPort, null, new LegacySslProvider(name));
    }

    public ConnectorFactory(String name, int listenPort, Element legacyConfig, SimpleComponent sslProviderComponent) {
        super(new ComponentModel(new BundleInstantiationSpecification(new ComponentId(name), ComponentSpecification.fromString((String)"com.yahoo.jdisc.http.server.jetty.ConnectorFactory"), ComponentSpecification.fromString((String)"jdisc_http_service"))));
        this.name = name;
        this.listenPort = listenPort;
        this.legacyConfig = legacyConfig;
        this.sslProviderComponent = sslProviderComponent;
        this.addChild(sslProviderComponent);
        this.inject(sslProviderComponent);
    }

    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        ConnectorFactory.configureWithLegacyHttpConfig(this.legacyConfig, connectorBuilder);
        connectorBuilder.listenPort(this.listenPort);
        connectorBuilder.name(this.name);
        ((ConnectorConfig.Producer)this.sslProviderComponent).getConfig(connectorBuilder);
    }

    public String getName() {
        return this.name;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    @Deprecated
    private static void configureWithLegacyHttpConfig(Element legacyConfig, ConnectorConfig.Builder connectorBuilder) {
        if (legacyConfig != null) {
            Element maxHeaderSize;
            Element sendBufferSize;
            Element soLinger;
            Element idleConnectionTimeout;
            Element tcpListenBacklogLength;
            Element tcpNoDelayEnabled;
            Element tcpKeepAliveEnabled = XML.getChild((Element)legacyConfig, (String)"tcpKeepAliveEnabled");
            if (tcpKeepAliveEnabled != null) {
                connectorBuilder.tcpKeepAliveEnabled(Boolean.valueOf(XML.getValue((Element)tcpKeepAliveEnabled).trim()).booleanValue());
            }
            if ((tcpNoDelayEnabled = XML.getChild((Element)legacyConfig, (String)"tcpNoDelayEnabled")) != null) {
                connectorBuilder.tcpNoDelay(Boolean.valueOf(XML.getValue((Element)tcpNoDelayEnabled).trim()).booleanValue());
            }
            if ((tcpListenBacklogLength = XML.getChild((Element)legacyConfig, (String)"tcpListenBacklogLength")) != null) {
                connectorBuilder.acceptQueueSize(Integer.parseInt(XML.getValue((Element)tcpListenBacklogLength).trim()));
            }
            if ((idleConnectionTimeout = XML.getChild((Element)legacyConfig, (String)"idleConnectionTimeout")) != null) {
                connectorBuilder.idleTimeout(Double.parseDouble(XML.getValue((Element)idleConnectionTimeout).trim()));
            }
            if ((soLinger = XML.getChild((Element)legacyConfig, (String)"soLinger")) != null) {
                connectorBuilder.soLingerTime(Double.parseDouble(XML.getValue((Element)soLinger).trim()));
            }
            if ((sendBufferSize = XML.getChild((Element)legacyConfig, (String)"sendBufferSize")) != null) {
                connectorBuilder.outputBufferSize(Integer.parseInt(XML.getValue((Element)sendBufferSize).trim()));
            }
            if ((maxHeaderSize = XML.getChild((Element)legacyConfig, (String)"maxHeaderSize")) != null) {
                connectorBuilder.headerCacheSize(Integer.parseInt(XML.getValue((Element)maxHeaderSize).trim()));
            }
            Element ssl = XML.getChild((Element)legacyConfig, (String)"ssl");
            Element sslEnabled = XML.getChild((Element)ssl, (String)"enabled");
            if (ssl != null && sslEnabled != null && Boolean.parseBoolean(XML.getValue((Element)sslEnabled).trim())) {
                Element protocol;
                Element algorithm;
                Element keyDBKey;
                Element trustStorePath;
                Element keyStorePath;
                ConnectorConfig.Ssl.Builder sslBuilder = new ConnectorConfig.Ssl.Builder();
                sslBuilder.enabled(true);
                Element keyStoreType = XML.getChild((Element)ssl, (String)"keyStoreType");
                if (keyStoreType != null) {
                    sslBuilder.keyStoreType(ConnectorConfig.Ssl.KeyStoreType.Enum.valueOf((String)XML.getValue((Element)keyStoreType).trim()));
                }
                if ((keyStorePath = XML.getChild((Element)ssl, (String)"keyStorePath")) != null) {
                    sslBuilder.keyStorePath(XML.getValue((Element)keyStorePath).trim());
                }
                if ((trustStorePath = XML.getChild((Element)ssl, (String)"trustStorePath")) != null) {
                    sslBuilder.trustStorePath(XML.getValue((Element)trustStorePath).trim());
                }
                if ((keyDBKey = XML.getChild((Element)ssl, (String)"keyDBKey")) != null) {
                    sslBuilder.keyDbKey(XML.getValue((Element)keyDBKey).trim());
                }
                if ((algorithm = XML.getChild((Element)ssl, (String)"algorithm")) != null) {
                    sslBuilder.sslKeyManagerFactoryAlgorithm(XML.getValue((Element)algorithm).trim());
                }
                if ((protocol = XML.getChild((Element)ssl, (String)"protocol")) != null) {
                    sslBuilder.protocol(XML.getValue((Element)protocol).trim());
                }
                connectorBuilder.ssl(sslBuilder);
            }
        }
    }
}

