/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Map;

public class RankingExpressionTypeResolver
extends Processor {
    private final QueryProfileRegistry queryProfiles;

    public RankingExpressionTypeResolver(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
        this.queryProfiles = queryProfiles.getRegistry();
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.search)) {
            try {
                this.resolveTypesIn(profile, validate);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("In " + this.search + ", " + profile, e);
            }
        }
    }

    private void resolveTypesIn(RankProfile profile, boolean validate) {
        TypeContext<Reference> context = profile.typeContext(this.queryProfiles);
        for (Map.Entry<String, RankProfile.RankingExpressionFunction> function : profile.getFunctions().entrySet()) {
            if (this.hasUntypedArguments(function.getValue().function())) continue;
            TensorType type = this.resolveType(function.getValue().function().getBody(), "function '" + function.getKey() + "'", context);
            function.getValue().setReturnType(type);
        }
        if (validate) {
            profile.getSummaryFeatures().forEach(f -> this.resolveType((ExpressionNode)f, "summary feature " + f, context));
            this.ensureValidDouble(profile.getFirstPhaseRanking(), "first-phase expression", context);
            this.ensureValidDouble(profile.getSecondPhaseRanking(), "second-phase expression", context);
        }
    }

    private boolean hasUntypedArguments(ExpressionFunction function) {
        return function.arguments().size() > function.argumentTypes().size();
    }

    private TensorType resolveType(RankingExpression expression, String expressionDescription, TypeContext context) {
        if (expression == null) {
            return null;
        }
        return this.resolveType(expression.getRoot(), expressionDescription, context);
    }

    private TensorType resolveType(ExpressionNode expression, String expressionDescription, TypeContext context) {
        TensorType type;
        try {
            type = expression.type(context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The " + expressionDescription + " is invalid", e);
        }
        if (type == null) {
            throw new IllegalStateException("Could not determine the type produced by " + expressionDescription);
        }
        return type;
    }

    private void ensureValidDouble(RankingExpression expression, String expressionDescription, TypeContext context) {
        if (expression == null) {
            return;
        }
        TensorType type = this.resolveType(expression, expressionDescription, context);
        if (!type.equals((Object)TensorType.empty)) {
            throw new IllegalArgumentException("The " + expressionDescription + " must produce a double (a tensor with no dimensions), but produces " + type);
        }
    }
}

