/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DeprecateAttributePrefetch
extends Processor {
    public DeprecateAttributePrefetch(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            for (Attribute a : field.getAttributes().values()) {
                if (Boolean.TRUE.equals(a.getPrefetchValue())) {
                    this.warn(this.search, field, "Attribute prefetch is deprecated. Use an explicitly defined document summary with all desired fields defined as attribute.");
                }
                if (!Boolean.FALSE.equals(a.getPrefetchValue())) continue;
                this.warn(this.search, field, "Attribute prefetch is deprecated. no-prefetch can be removed.");
            }
        }
    }
}

