/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IndexingOutputs
extends Processor {
    public IndexingOutputs(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        for (SDField field : this.search.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            if (script == null) continue;
            TreeSet<String> summaryFields = new TreeSet<String>();
            this.findSummaryTo(this.search, field, summaryFields, summaryFields);
            MyConverter converter = new MyConverter(this.search, field, summaryFields, validate);
            field.setIndexingScript((ScriptExpression)converter.convert((Expression)script));
        }
    }

    public void findSummaryTo(Search search, SDField field, Set<String> dynamicSummary, Set<String> staticSummary) {
        Map<String, SummaryField> summaryFields = search.getSummaryFields(field);
        if (summaryFields.isEmpty()) {
            IndexingOutputs.fillSummaryToFromField(field, dynamicSummary, staticSummary);
        } else {
            this.fillSummaryToFromSearch(search, field, summaryFields, dynamicSummary, staticSummary);
        }
    }

    private void fillSummaryToFromSearch(Search search, SDField field, Map<String, SummaryField> summaryFields, Set<String> dynamicSummary, Set<String> staticSummary) {
        for (SummaryField summaryField : summaryFields.values()) {
            this.fillSummaryToFromSummaryField(search, field, summaryField, dynamicSummary, staticSummary);
        }
    }

    private void fillSummaryToFromSummaryField(Search search, SDField field, SummaryField summaryField, Set<String> dynamicSummary, Set<String> staticSummary) {
        SummaryTransform summaryTransform = summaryField.getTransform();
        String summaryName = summaryField.getName();
        if (summaryTransform.isDynamic() && summaryField.getSourceCount() > 2) {
            return;
        }
        if (summaryTransform.isDynamic()) {
            DataType fieldType = field.getDataType();
            if (fieldType != DataType.URI && fieldType != DataType.STRING) {
                this.warn(search, field, "Dynamic summaries are only supported for fields of type string, ignoring summary field '" + summaryField.getName() + "' for sd field '" + field.getName() + "' of type " + fieldType.getName() + ".");
                return;
            }
            dynamicSummary.add(summaryName);
        } else if (summaryTransform != SummaryTransform.ATTRIBUTE) {
            staticSummary.add(summaryName);
        }
    }

    private static void fillSummaryToFromField(SDField field, Set<String> dynamicSummary, Set<String> staticSummary) {
        for (SummaryField summaryField : field.getSummaryFields()) {
            String summaryName = summaryField.getName();
            if (summaryField.getTransform().isDynamic()) {
                dynamicSummary.add(summaryName);
                continue;
            }
            staticSummary.add(summaryName);
        }
    }

    private class MyConverter
    extends ExpressionConverter {
        final Search search;
        final Field field;
        final Set<String> summaryFields;
        final boolean validate;

        MyConverter(Search search, Field field, Set<String> summaryFields, boolean validate) {
            this.search = search;
            this.field = field;
            this.summaryFields = summaryFields.isEmpty() ? Collections.singleton(field.getName()) : summaryFields;
            this.validate = validate;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof OutputExpression)) {
                return false;
            }
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (fieldName == null) {
                return true;
            }
            if (this.validate && !fieldName.equals(this.field.getName())) {
                IndexingOutputs.this.fail(this.search, this.field, "Indexing expression '" + exp + "' attempts to write to a field other than '" + this.field.getName() + "'.");
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            LinkedList<Object> ret = new LinkedList<Object>();
            if (exp instanceof AttributeExpression) {
                ret.add(new AttributeExpression(this.field.getName()));
            } else if (exp instanceof IndexExpression) {
                ret.add(new IndexExpression(this.field.getName()));
            } else if (exp instanceof SummaryExpression) {
                for (String fieldName : this.summaryFields) {
                    ret.add(new SummaryExpression(fieldName));
                }
            } else {
                throw new UnsupportedOperationException(exp.getClass().getName());
            }
            return new StatementExpression(ret);
        }
    }
}

