/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.Version;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminBuilderBase;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class DomAdminV4Builder
extends DomAdminBuilderBase {
    private final Collection<ContainerModel> containerModels;
    private final ConfigModelContext context;

    public DomAdminV4Builder(ConfigModelContext context, boolean multitenant, List<ConfigServerSpec> configServerSpecs, Collection<ContainerModel> containerModels) {
        super(context.getApplicationType(), context.getDeployState().getFileRegistry(), multitenant, configServerSpecs);
        this.containerModels = containerModels;
        this.context = context;
    }

    @Override
    protected void doBuildAdmin(Admin admin, Element w3cAdminElement) {
        ModelElement adminElement = new ModelElement(w3cAdminElement);
        admin.addConfigservers(this.getConfigServersFromSpec(admin));
        Version version = this.context.getDeployState().getWantedNodeVespaVersion();
        Optional<NodesSpecification> requestedSlobroks = NodesSpecification.optionalDedicatedFromParent(adminElement.getChild("slobroks"), version);
        Optional<NodesSpecification> requestedLogservers = NodesSpecification.optionalDedicatedFromParent(adminElement.getChild("logservers"), version);
        this.assignSlobroks(requestedSlobroks.orElse(NodesSpecification.nonDedicated(3, version)), admin);
        this.assignLogserver(requestedLogservers.orElse(NodesSpecification.nonDedicated(1, version)), admin);
        this.addLogForwarders(adminElement.getChild("logforwarding"), admin);
    }

    private void assignSlobroks(NodesSpecification nodesSpecification, Admin admin) {
        if (nodesSpecification.isDedicated()) {
            this.createSlobroks(admin, this.allocateHosts(admin.getHostSystem(), "slobroks", nodesSpecification));
        } else {
            this.createSlobroks(admin, this.pickContainerHosts(nodesSpecification.count(), 2));
        }
    }

    private void assignLogserver(NodesSpecification nodesSpecification, Admin admin) {
        if (nodesSpecification.count() > 1) {
            throw new IllegalArgumentException("You can only request a single log server");
        }
        if (nodesSpecification.isDedicated()) {
            this.createLogserver(admin, this.allocateHosts(admin.getHostSystem(), "logserver", nodesSpecification));
        } else if (this.containerModels.iterator().hasNext()) {
            this.createLogserver(admin, this.sortedContainerHostsFrom(this.containerModels.iterator().next(), nodesSpecification.count(), false));
        }
    }

    private Collection<HostResource> allocateHosts(HostSystem hostSystem, String clusterId, NodesSpecification nodesSpecification) {
        return nodesSpecification.provision(hostSystem, ClusterSpec.Type.admin, ClusterSpec.Id.from((String)clusterId), this.context.getDeployLogger()).keySet();
    }

    private List<HostResource> pickContainerHosts(int count, int minHostsPerContainerCluster) {
        ArrayList<HostResource> picked = new ArrayList<HostResource>();
        for (ContainerModel containerModel : this.containerModels) {
            picked.addAll(this.pickContainerHostsFrom(containerModel, (int)Math.max((double)minHostsPerContainerCluster, Math.ceil((double)count / (double)this.containerModels.size()))));
        }
        return picked;
    }

    private List<HostResource> pickContainerHostsFrom(ContainerModel model, int count) {
        boolean retired = true;
        List<HostResource> picked = this.sortedContainerHostsFrom(model, count, !retired);
        picked.addAll(this.sortedContainerHostsFrom(model, count, retired));
        return picked;
    }

    private List<HostResource> sortedContainerHostsFrom(ContainerModel model, int count, boolean retired) {
        ArrayList<HostResource> hosts = new ArrayList<HostResource>();
        for (Container container : model.getCluster().getContainers()) {
            if (retired != container.isRetired()) continue;
            hosts.add(container.getHostResource());
        }
        Collections.sort(hosts);
        return hosts.subList(0, Math.min(count, hosts.size()));
    }

    private void createLogserver(Admin admin, Collection<HostResource> hosts) {
        if (hosts.isEmpty()) {
            return;
        }
        Logserver logserver = new Logserver(admin);
        logserver.setHostResource(hosts.iterator().next());
        admin.setLogserver(logserver);
        logserver.initService();
    }

    private void createSlobroks(Admin admin, Collection<HostResource> hosts) {
        if (hosts.isEmpty()) {
            return;
        }
        ArrayList<Slobrok> slobroks = new ArrayList<Slobrok>();
        int index = 0;
        for (HostResource host : hosts) {
            Slobrok slobrok = new Slobrok((AbstractConfigProducer)admin, index++);
            slobrok.setHostResource(host);
            slobroks.add(slobrok);
            slobrok.initService();
        }
        admin.addSlobroks(slobroks);
    }
}

