/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SummaryFieldsMustHaveValidSource
extends Processor {
    SummaryFieldsMustHaveValidSource(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (DocumentSummary summary : this.search.getSummaries().values()) {
            for (SummaryField summaryField : summary.getSummaryFields()) {
                if (summaryField.getSources().isEmpty()) {
                    if (summaryField.getTransform() == SummaryTransform.RANKFEATURES || summaryField.getTransform() == SummaryTransform.SUMMARYFEATURES) continue;
                    this.verifySource(summaryField.getName(), summaryField, summary);
                    continue;
                }
                if (summaryField.getSourceCount() == 1) {
                    this.verifySource(summaryField.getSingleSource(), summaryField, summary);
                    continue;
                }
                for (SummaryField.Source source : summaryField.getSources()) {
                    if (source.getName().equals(summaryField.getName())) continue;
                    this.verifySource(source.getName(), summaryField, summary);
                }
            }
        }
    }

    private boolean isValid(String source, SummaryField summaryField, DocumentSummary summary) {
        return this.isDocumentField(source) || SummaryFieldsMustHaveValidSource.isNotInThisSummaryClass(summary, source) && this.isSummaryField(source) || SummaryFieldsMustHaveValidSource.isInThisSummaryClass(summary, source) && !source.equals(summaryField.getName()) || "documentid".equals(source);
    }

    private void verifySource(String source, SummaryField summaryField, DocumentSummary summary) {
        if (!this.isValid(source, summaryField, summary)) {
            throw new IllegalArgumentException("For search '" + this.search.getName() + "', summary class '" + summary.getName() + "', summary field '" + summaryField.getName() + "': there is no valid source '" + source + "'.");
        }
    }

    private static boolean isNotInThisSummaryClass(DocumentSummary summary, String name) {
        return summary.getSummaryField(name) == null;
    }

    private static boolean isInThisSummaryClass(DocumentSummary summary, String name) {
        return summary.getSummaryField(name) != null;
    }

    private boolean isDocumentField(String name) {
        return this.search.getField(name) != null;
    }

    private boolean isSummaryField(String name) {
        return this.search.getSummaryField(name) != null;
    }
}

