/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ValidationOverrides {
    public static final ValidationOverrides empty = new ValidationOverrides(List.of(), "<validation-overrides/>");
    private final List<Allow> overrides;
    private final String xmlForm;

    public ValidationOverrides(List<Allow> overrides) {
        this(overrides, null);
    }

    private ValidationOverrides(List<Allow> overrides, String xmlForm) {
        this.overrides = List.copyOf(overrides);
        this.xmlForm = xmlForm;
    }

    public void invalid(Map<ValidationId, ? extends Collection<String>> messagesByValidationId, Instant now) {
        HashMap<ValidationId, Collection<String>> disallowed = new HashMap<ValidationId, Collection<String>>(messagesByValidationId);
        disallowed.keySet().removeIf(id -> this.allows((ValidationId)((Object)id), now));
        if (!disallowed.isEmpty()) {
            throw new ValidationException(disallowed);
        }
    }

    public void invalid(ValidationId validationId, String message, Instant now) {
        if (!this.allows(validationId, now)) {
            throw new ValidationException(validationId, message);
        }
    }

    public boolean allows(String validationIdString, Instant now) {
        Optional<ValidationId> validationId = ValidationId.from(validationIdString);
        if (validationId.isEmpty()) {
            return false;
        }
        return this.allows(validationId.get(), now);
    }

    public boolean allows(ValidationId validationId, Instant now) {
        for (Allow override : this.overrides) {
            if (!override.allows(validationId, now)) continue;
            return true;
        }
        return false;
    }

    public boolean validate(Instant now) {
        for (Allow override : this.overrides) {
            if (!now.plus(Duration.ofDays(30L)).isBefore(override.until)) continue;
            throw new IllegalArgumentException("validation-overrides is invalid: " + override + " is too far in the future: Max 30 days is allowed");
        }
        return false;
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public static String toAllowMessage(ValidationId id) {
        return "To allow this add <allow until='yyyy-mm-dd'>" + id + "</allow> to validation-overrides.xml, see https://docs.vespa.ai/en/reference/validation-overrides.html";
    }

    public static ValidationOverrides fromXml(Reader reader) {
        try {
            return ValidationOverrides.fromXml(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read validation-overrides", e);
        }
    }

    public static ValidationOverrides fromXml(String xmlForm) {
        if (xmlForm.isEmpty()) {
            return empty;
        }
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        ArrayList<Allow> overrides = new ArrayList<Allow>();
        for (Element allow : XML.getChildren((Element)root, (String)"allow")) {
            try {
                Instant until = LocalDate.parse(allow.getAttribute("until"), DateTimeFormatter.ISO_DATE).atStartOfDay().atZone(ZoneOffset.UTC).toInstant().plus(Duration.ofDays(1L));
                Optional<ValidationId> validationId = ValidationId.from(XML.getValue((Element)allow));
                validationId.ifPresent(id -> overrides.add(new Allow((ValidationId)((Object)id), until)));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new ValidationOverrides(overrides, xmlForm);
    }

    public static class ValidationException
    extends IllegalArgumentException {
        static final long serialVersionUID = 789984668L;

        private ValidationException(ValidationId validationId, String message) {
            super(validationId + ": " + message + ". " + ValidationOverrides.toAllowMessage(validationId));
        }

        private ValidationException(Map<ValidationId, Collection<String>> messagesById) {
            super(messagesById.entrySet().stream().map(messages -> messages.getKey() + ":\n\t" + String.join((CharSequence)"\n\t", (Iterable)messages.getValue()) + "\n" + ValidationOverrides.toAllowMessage((ValidationId)((Object)((Object)messages.getKey())))).collect(Collectors.joining("\n")));
        }
    }

    public static class Allow {
        private final ValidationId validationId;
        private final Instant until;

        public Allow(ValidationId validationId, Instant until) {
            this.validationId = validationId;
            this.until = until;
        }

        public boolean allows(ValidationId validationId, Instant now) {
            return this.validationId.equals((Object)validationId) && now.isBefore(this.until);
        }

        public String toString() {
            return "allow '" + this.validationId + "' until " + this.until;
        }
    }
}

