/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api.xml;

import com.yahoo.config.application.api.Bcp;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Tags;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentSpecXmlReader {
    private static final String deploymentTag = "deployment";
    private static final String instanceTag = "instance";
    private static final String tagsTag = "tags";
    private static final String testTag = "test";
    private static final String stagingTag = "staging";
    private static final String devTag = "dev";
    private static final String perfTag = "perf";
    private static final String upgradeTag = "upgrade";
    private static final String blockChangeTag = "block-change";
    private static final String prodTag = "prod";
    private static final String regionTag = "region";
    private static final String delayTag = "delay";
    private static final String parallelTag = "parallel";
    private static final String stepsTag = "steps";
    private static final String endpointsTag = "endpoints";
    private static final String endpointTag = "endpoint";
    private static final String notificationsTag = "notifications";
    private static final String idAttribute = "id";
    private static final String athenzServiceAttribute = "athenz-service";
    private static final String athenzDomainAttribute = "athenz-domain";
    private static final String testerFlavorAttribute = "tester-flavor";
    private static final String majorVersionAttribute = "major-version";
    private static final String cloudAccountAttribute = "cloud-account";
    private static final String hostTTLAttribute = "empty-host-ttl";
    private final boolean validate;
    private final Clock clock;
    private final List<DeploymentSpec.DeprecatedElement> deprecatedElements = new ArrayList<DeploymentSpec.DeprecatedElement>();

    public DeploymentSpecXmlReader(boolean validate, Clock clock) {
        this.validate = validate;
        this.clock = clock;
    }

    public DeploymentSpecXmlReader() {
        this(true);
    }

    public DeploymentSpecXmlReader(boolean validate) {
        this(validate, Clock.systemUTC());
    }

    public DeploymentSpec read(Reader reader) {
        try {
            return this.read(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public DeploymentSpec read(String xmlForm) {
        this.deprecatedElements.clear();
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        if (!root.getTagName().equals(deploymentTag)) {
            DeploymentSpecXmlReader.illegal("The root tag must be <deployment>");
        }
        if (DeploymentSpecXmlReader.isEmptySpec(root)) {
            return DeploymentSpec.empty;
        }
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        ArrayList<Endpoint> applicationEndpoints = new ArrayList<Endpoint>();
        if (!this.containsTag(instanceTag, root)) {
            steps.addAll(this.readInstanceContent("default", root, new HashMap<String, String>(), root, Bcp.empty()));
        } else {
            if (XML.getChildren((Element)root).stream().anyMatch(child -> child.getTagName().equals(prodTag))) {
                DeploymentSpecXmlReader.illegal("A deployment spec cannot have both a <prod> tag and an <instance> tag under the root: Wrap the prod tags inside the appropriate instance");
            }
            for (Element child2 : XML.getChildren((Element)root)) {
                String tagName = child2.getTagName();
                Bcp defaultBcp = DeploymentSpecXmlReader.readBcp(root, Optional.empty(), List.of(), List.of(), Map.of());
                if (tagName.equals(instanceTag)) {
                    steps.addAll(this.readInstanceContent(child2.getAttribute(idAttribute), child2, new HashMap<String, String>(), root, defaultBcp));
                    continue;
                }
                steps.addAll(this.readNonInstanceSteps(child2, new HashMap<String, String>(), root, defaultBcp));
            }
            this.readEndpoints(root, Optional.empty(), steps, applicationEndpoints, Map.of());
        }
        return new DeploymentSpec(steps, this.optionalIntegerAttribute(majorVersionAttribute, root), DeploymentSpecXmlReader.stringAttribute(athenzDomainAttribute, root).map(AthenzDomain::from), DeploymentSpecXmlReader.stringAttribute(athenzServiceAttribute, root).map(AthenzService::from), this.readCloudAccounts(root), DeploymentSpecXmlReader.stringAttribute(hostTTLAttribute, root).map(s -> DeploymentSpecXmlReader.toDuration(s, "empty host TTL")), applicationEndpoints, xmlForm, this.deprecatedElements);
    }

    private List<DeploymentInstanceSpec> readInstanceContent(String instanceNameString, Element instanceElement, Map<String, String> prodAttributes, Element parentTag, Bcp defaultBcp) {
        if (instanceNameString.isBlank()) {
            DeploymentSpecXmlReader.illegal("<instance> attribute 'id' must be specified, and not be blank");
        }
        if (XML.getChildren((Element)instanceElement).isEmpty() && (instanceElement.getAttributes().getLength() == 0 || instanceElement == parentTag)) {
            return List.of();
        }
        if (this.validate) {
            this.validateTagOrder(instanceElement);
        }
        DeploymentSpec.UpgradePolicy upgradePolicy = this.getWithFallback(instanceElement, parentTag, upgradeTag, "policy", this::readUpgradePolicy, DeploymentSpec.UpgradePolicy.defaultPolicy);
        DeploymentSpec.RevisionTarget revisionTarget = this.getWithFallback(instanceElement, parentTag, upgradeTag, "revision-target", this::readRevisionTarget, DeploymentSpec.RevisionTarget.latest);
        DeploymentSpec.RevisionChange revisionChange = this.getWithFallback(instanceElement, parentTag, upgradeTag, "revision-change", this::readRevisionChange, DeploymentSpec.RevisionChange.whenFailing);
        DeploymentSpec.UpgradeRollout upgradeRollout = this.getWithFallback(instanceElement, parentTag, upgradeTag, "rollout", this::readUpgradeRollout, DeploymentSpec.UpgradeRollout.separate);
        int minRisk = this.getWithFallback(instanceElement, parentTag, upgradeTag, "min-risk", Integer::parseInt, 0);
        int maxRisk = this.getWithFallback(instanceElement, parentTag, upgradeTag, "max-risk", Integer::parseInt, 0);
        int maxIdleHours = this.getWithFallback(instanceElement, parentTag, upgradeTag, "max-idle-hours", Integer::parseInt, 8);
        List<DeploymentSpec.ChangeBlocker> changeBlockers = this.readChangeBlockers(instanceElement, parentTag);
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(instanceElement, athenzServiceAttribute).map(AthenzService::from);
        Map<CloudName, CloudAccount> cloudAccounts = this.readCloudAccounts(instanceElement);
        Optional<Duration> hostTTL = DeploymentSpecXmlReader.mostSpecificAttribute(instanceElement, hostTTLAttribute).map(s -> DeploymentSpecXmlReader.toDuration(s, "empty host TTL"));
        Notifications notifications = this.readNotifications(instanceElement, parentTag);
        Tags tags = XML.attribute((String)tagsTag, (Element)instanceElement).map(Tags::fromString).orElse(Tags.empty());
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        for (Element instanceChild : XML.getChildren((Element)instanceElement)) {
            steps.addAll(this.readNonInstanceSteps(instanceChild, prodAttributes, instanceChild, defaultBcp));
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        LinkedHashMap<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> zoneEndpoints = new LinkedHashMap<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>>();
        this.readEndpoints(instanceElement, Optional.of(instanceNameString), steps, endpoints, zoneEndpoints);
        Bcp bcp = this.complete(DeploymentSpecXmlReader.readBcp(instanceElement, Optional.of(instanceNameString), steps, endpoints, zoneEndpoints).orElse(defaultBcp), steps);
        this.validateEndpoints(endpoints);
        Instant now = this.clock.instant();
        return Arrays.stream(instanceNameString.split(",")).map(name -> name.trim()).map(name -> new DeploymentInstanceSpec(InstanceName.from((String)name), tags, steps, upgradePolicy, revisionTarget, revisionChange, upgradeRollout, minRisk, maxRisk, maxIdleHours, changeBlockers, athenzService, cloudAccounts, hostTTL, notifications, endpoints, zoneEndpoints, bcp, now)).toList();
    }

    private void validateEndpoints(List<Endpoint> endpoints) {
        HashSet<String> endpointIds = new HashSet<String>();
        for (Endpoint endpoint : endpoints) {
            if (endpointIds.add(endpoint.endpointId())) continue;
            DeploymentSpecXmlReader.illegal("Endpoint id '" + endpoint.endpointId() + "' is specified multiple times");
        }
    }

    private List<DeploymentSpec.Step> readSteps(Element stepTag, Map<String, String> prodAttributes, Element parentTag, Bcp defaultBcp) {
        if (stepTag.getTagName().equals(instanceTag)) {
            return new ArrayList<DeploymentSpec.Step>(this.readInstanceContent(stepTag.getAttribute(idAttribute), stepTag, prodAttributes, parentTag, defaultBcp));
        }
        return this.readNonInstanceSteps(stepTag, prodAttributes, parentTag, defaultBcp);
    }

    private List<DeploymentSpec.Step> readNonInstanceSteps(Element stepTag, Map<String, String> prodAttributes, Element parentTag, Bcp defaultBcp) {
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, athenzServiceAttribute).map(AthenzService::from);
        Optional<String> testerFlavor = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, testerFlavorAttribute);
        switch (stepTag.getTagName()) {
            case "test": {
                if (Stream.iterate(stepTag, Objects::nonNull, Node::getParentNode).anyMatch(node -> prodTag.equals(node.getNodeName()))) {
                    return List.of(new DeploymentSpec.DeclaredTest(RegionName.from((String)XML.getValue((Element)stepTag).trim()), this.readHostTTL(stepTag)));
                }
            }
            case "dev": 
            case "perf": 
            case "staging": {
                return List.of(new DeploymentSpec.DeclaredZone(Environment.from((String)stepTag.getTagName()), Optional.empty(), athenzService, testerFlavor, this.readCloudAccounts(stepTag), this.readHostTTL(stepTag)));
            }
            case "prod": {
                return XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readNonInstanceSteps((Element)child, prodAttributes, stepTag, defaultBcp).stream()).toList();
            }
            case "delay": {
                return List.of(new DeploymentSpec.Delay(Duration.ofSeconds(this.longAttribute("hours", stepTag) * 60L * 60L + this.longAttribute("minutes", stepTag) * 60L + this.longAttribute("seconds", stepTag))));
            }
            case "parallel": {
                return List.of(new DeploymentSpec.ParallelSteps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, prodAttributes, parentTag, defaultBcp).stream()).toList()));
            }
            case "steps": {
                return List.of(new DeploymentSpec.Steps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, prodAttributes, parentTag, defaultBcp).stream()).toList()));
            }
            case "region": {
                return List.of(this.readDeclaredZone(Environment.prod, athenzService, testerFlavor, stepTag));
            }
        }
        return List.of();
    }

    private boolean containsTag(String childTagName, Element parent) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!child.getTagName().equals(childTagName) && !this.containsTag(childTagName, child)) continue;
            return true;
        }
        return false;
    }

    private Notifications readNotifications(Element parent, Element fallbackParent) {
        Element notificationsElement = XML.getChild((Element)parent, (String)notificationsTag);
        if (notificationsElement == null) {
            notificationsElement = XML.getChild((Element)fallbackParent, (String)notificationsTag);
        }
        if (notificationsElement == null) {
            return Notifications.none();
        }
        Notifications.When defaultWhen = DeploymentSpecXmlReader.stringAttribute("when", notificationsElement).map(Notifications.When::fromValue).orElse(Notifications.When.failingCommit);
        HashMap<Notifications.When, List<String>> emailAddresses = new HashMap<Notifications.When, List<String>>();
        HashMap<Notifications.When, List<Notifications.Role>> emailRoles = new HashMap<Notifications.When, List<Notifications.Role>>();
        for (Notifications.When when : Notifications.When.values()) {
            emailAddresses.put(when, new ArrayList());
            emailRoles.put(when, new ArrayList());
        }
        for (Element emailElement : XML.getChildren((Element)notificationsElement, (String)"email")) {
            Optional<String> addressAttribute = DeploymentSpecXmlReader.stringAttribute("address", emailElement);
            Optional<Notifications.Role> roleAttribute = DeploymentSpecXmlReader.stringAttribute("role", emailElement).map(Notifications.Role::fromValue);
            Notifications.When when = DeploymentSpecXmlReader.stringAttribute("when", emailElement).map(Notifications.When::fromValue).orElse(defaultWhen);
            if (addressAttribute.isPresent() == roleAttribute.isPresent()) {
                DeploymentSpecXmlReader.illegal("Exactly one of 'role' and 'address' must be present in 'email' elements.");
            }
            addressAttribute.ifPresent(address -> ((List)emailAddresses.get((Object)when)).add(address));
            roleAttribute.ifPresent(role -> ((List)emailRoles.get((Object)when)).add(role));
        }
        return Notifications.of(emailAddresses, emailRoles);
    }

    private void readEndpoints(Element parent, Optional<String> instance, List<DeploymentSpec.Step> steps, List<Endpoint> endpoints, Map<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> zoneEndpoints) {
        Element endpointsElement = XML.getChild((Element)parent, (String)endpointsTag);
        if (endpointsElement == null) {
            return;
        }
        Endpoint.Level level = instance.isEmpty() ? Endpoint.Level.application : Endpoint.Level.instance;
        LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>> endpointsByZone = new LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>>();
        for (Element endpointElement : XML.getChildren((Element)endpointsElement, (String)endpointTag).stream().sorted(Comparator.comparingInt(endpoint -> DeploymentSpecXmlReader.getZoneEndpointType(endpoint, level).isPresent() ? 0 : 1)).toList()) {
            Optional<Endpoint> endpoint2 = DeploymentSpecXmlReader.readEndpoint(parent, endpointElement, level, instance, steps, List.of(), endpointsByZone);
            endpoint2.ifPresent(e -> endpoints.add((Endpoint)e));
        }
        DeploymentSpecXmlReader.validateAndConsolidate(endpointsByZone, zoneEndpoints);
    }

    /*
     * WARNING - void declaration
     */
    static Optional<Endpoint> readEndpoint(Element parentElement, Element endpointElement, Endpoint.Level level, Optional<String> instance, List<DeploymentSpec.Step> steps, Collection<RegionName> forRegions, Map<String, Map<RegionName, List<ZoneEndpoint>>> endpointsByZone) {
        String invalidChild;
        String containerId = DeploymentSpecXmlReader.requireStringAttribute("container-id", endpointElement);
        Optional<String> endpointId = DeploymentSpecXmlReader.stringAttribute(idAttribute, endpointElement);
        Optional<String> zoneEndpointType = DeploymentSpecXmlReader.getZoneEndpointType(endpointElement, level);
        String msgPrefix = (level == Endpoint.Level.application ? "Application-level" : "Instance-level") + " endpoint '" + endpointId.orElse("default") + "': ";
        if (zoneEndpointType.isPresent() && endpointId.isPresent()) {
            DeploymentSpecXmlReader.illegal(msgPrefix + "cannot declare 'id' with type 'zone' or 'private'");
        }
        String string = invalidChild = level == Endpoint.Level.application ? regionTag : instanceTag;
        if (!XML.getChildren((Element)endpointElement, (String)invalidChild).isEmpty()) {
            DeploymentSpecXmlReader.illegal(msgPrefix + "invalid element '" + invalidChild + "'");
        }
        boolean enabled = XML.attribute((String)"enabled", (Element)endpointElement).map(value -> {
            if (zoneEndpointType.isEmpty() || !((String)zoneEndpointType.get()).equals("zone")) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "only endpoints of type 'zone' can specify 'enabled'");
            }
            return switch (value) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException(msgPrefix + "invalid 'enabled' value; must be 'true' or 'false'");
            };
        }).orElse(true);
        ArrayList<ZoneEndpoint.AllowedUrn> allowedUrns = new ArrayList<ZoneEndpoint.AllowedUrn>();
        block18: for (Element allow : XML.getChildren((Element)endpointElement, (String)"allow")) {
            if (zoneEndpointType.isEmpty() || !zoneEndpointType.get().equals("private")) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "only endpoints of type 'private' can specify 'allow' children");
            }
            switch (DeploymentSpecXmlReader.requireStringAttribute("with", allow)) {
                case "aws-private-link": {
                    allowedUrns.add(new ZoneEndpoint.AllowedUrn(ZoneEndpoint.AccessType.awsPrivateLink, DeploymentSpecXmlReader.requireStringAttribute("arn", allow)));
                    continue block18;
                }
                case "gcp-service-connect": {
                    allowedUrns.add(new ZoneEndpoint.AllowedUrn(ZoneEndpoint.AccessType.gcpServiceConnect, DeploymentSpecXmlReader.requireStringAttribute("project", allow)));
                    continue block18;
                }
            }
            DeploymentSpecXmlReader.illegal("Private endpoint for container-id '" + containerId + "': invalid attribute 'with': '" + DeploymentSpecXmlReader.requireStringAttribute("with", allow) + "'");
        }
        ArrayList<Endpoint.Target> targets = new ArrayList<Endpoint.Target>();
        if (level == Endpoint.Level.application) {
            if (!forRegions.isEmpty()) {
                throw new IllegalStateException("Illegal combination");
            }
            Optional<String> endpointRegion = DeploymentSpecXmlReader.stringAttribute(regionTag, endpointElement);
            int weightSum = 0;
            for (Element instanceElement : XML.getChildren((Element)endpointElement, (String)instanceTag)) {
                int weight;
                String string2 = instanceElement.getTextContent();
                if (string2 == null || string2.isBlank()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'instance' element");
                }
                Optional<String> instanceRegion = DeploymentSpecXmlReader.stringAttribute(regionTag, instanceElement);
                if (endpointRegion.isPresent() == instanceRegion.isPresent()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "'region' attribute must be declared on either <endpoint> or <instance> tag");
                }
                String weightFromAttribute = DeploymentSpecXmlReader.requireStringAttribute("weight", instanceElement);
                try {
                    weight = Integer.parseInt(weightFromAttribute);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(msgPrefix + "invalid weight value '" + weightFromAttribute + "'");
                }
                weightSum += weight;
                targets.add(new Endpoint.Target(RegionName.from((String)endpointRegion.orElseGet(instanceRegion::get)), InstanceName.from((String)string2), weight));
            }
            if (weightSum == 0) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "sum of all weights must be positive, got " + weightSum);
            }
        } else {
            if (DeploymentSpecXmlReader.stringAttribute(regionTag, endpointElement).isPresent()) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "invalid 'region' attribute");
            }
            LinkedHashSet<RegionName> regions = new LinkedHashSet<RegionName>(forRegions);
            List regionElements = XML.getChildren((Element)endpointElement, (String)regionTag);
            if (!regions.isEmpty() && !regionElements.isEmpty()) {
                DeploymentSpecXmlReader.illegal("Endpoints in <" + parentElement.getTagName() + "> cannot contain <region> children");
            }
            for (Element regionElement : XML.getChildren((Element)endpointElement, (String)regionTag)) {
                String string3 = regionElement.getTextContent();
                if (string3 == null || string3.isBlank()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'region' element");
                }
                if (zoneEndpointType.isEmpty()) {
                    if (Stream.of(RegionName.from((String)string3), null).map(endpointsByZone.getOrDefault(containerId, new HashMap())::get).flatMap(maybeEndpoints -> maybeEndpoints == null ? Stream.empty() : maybeEndpoints.stream()).anyMatch(endpoint -> !endpoint.isPublicEndpoint())) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "targets zone endpoint in '" + string3 + "' with 'enabled' set to 'false'");
                    }
                }
                if (regions.add(RegionName.from((String)string3))) continue;
                DeploymentSpecXmlReader.illegal(msgPrefix + "duplicate 'region' element: '" + string3 + "'");
            }
            if (zoneEndpointType.isPresent()) {
                void var19_28;
                if (regions.isEmpty()) {
                    regions.add(null);
                }
                Iterator iterator = zoneEndpointType.get();
                int n = -1;
                switch (((String)((Object)iterator)).hashCode()) {
                    case 3744684: {
                        if (!((String)((Object)iterator)).equals("zone")) break;
                        boolean bl = false;
                        break;
                    }
                    case -314497661: {
                        if (!((String)((Object)iterator)).equals("private")) break;
                        boolean bl = true;
                    }
                }
                ZoneEndpoint endpoint2 = switch (var19_28) {
                    case 0 -> new ZoneEndpoint(enabled, false, List.of());
                    case 1 -> new ZoneEndpoint(true, true, allowedUrns);
                    default -> throw new IllegalArgumentException("unsupported zone endpoint type '" + zoneEndpointType.get() + "'");
                };
                for (RegionName regionName : regions) {
                    endpointsByZone.computeIfAbsent(containerId, __ -> new LinkedHashMap()).computeIfAbsent(regionName, __ -> new ArrayList()).add(endpoint2);
                }
            } else {
                if (regions.isEmpty()) {
                    List declared = steps.stream().filter(step -> step.concerns(Environment.prod)).flatMap(step -> step.zones().stream()).flatMap(zone -> zone.region().stream()).toList();
                    if (declared.isEmpty()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "no declared regions to target");
                    }
                    declared.stream().filter(region -> Stream.of(region, null).map(endpointsByZone.getOrDefault(containerId, new HashMap())::get).flatMap(maybeEndpoints -> maybeEndpoints == null ? Stream.empty() : maybeEndpoints.stream()).allMatch(ZoneEndpoint::isPublicEndpoint)).forEach(regions::add);
                }
                if (regions.isEmpty()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "all eligible zone endpoints have 'enabled' set to 'false'");
                }
                InstanceName instanceName = instance.map(InstanceName::from).get();
                for (RegionName regionName : regions) {
                    targets.add(new Endpoint.Target(regionName, instanceName, 1));
                }
            }
        }
        if (zoneEndpointType.isEmpty()) {
            return Optional.of(new Endpoint(endpointId.orElse("default"), containerId, level, targets));
        }
        return Optional.empty();
    }

    static Bcp readBcp(Element parent, Optional<String> instance, List<DeploymentSpec.Step> steps, List<Endpoint> endpoints, Map<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> zoneEndpoints) {
        Element bcpElement = XML.getChild((Element)parent, (String)"bcp");
        if (bcpElement == null) {
            return Bcp.empty();
        }
        Optional<Duration> defaultDeadline = XML.attribute((String)"deadline", (Element)bcpElement).map(value -> DeploymentSpecXmlReader.toDuration(value, "deadline"));
        ArrayList<Bcp.Group> groups = new ArrayList<Bcp.Group>();
        LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>> endpointsByZone = new LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>>();
        for (Element groupElement : XML.getChildren((Element)bcpElement, (String)"group")) {
            ArrayList<Bcp.RegionMember> regions = new ArrayList<Bcp.RegionMember>();
            for (Element regionElement : XML.getChildren((Element)groupElement, (String)regionTag)) {
                double fraction = DeploymentSpecXmlReader.toDouble(XML.attribute((String)"fraction", (Element)regionElement).orElse(null), "fraction").orElse(1.0);
                regions.add(new Bcp.RegionMember(RegionName.from((String)XML.getValue((Element)regionElement)), fraction));
            }
            for (Element endpointElement : XML.getChildren((Element)groupElement, (String)endpointTag)) {
                if (instance.isEmpty()) {
                    DeploymentSpecXmlReader.illegal("The default <bcp> element at the root cannot define endpoints");
                }
                Optional<Endpoint> endpoint = DeploymentSpecXmlReader.readEndpoint(groupElement, endpointElement, Endpoint.Level.instance, instance, steps, regions.stream().map(r -> r.region()).toList(), endpointsByZone);
                endpoint.ifPresent(e -> endpoints.add((Endpoint)e));
            }
            Duration deadline = XML.attribute((String)"deadline", (Element)groupElement).map(value -> DeploymentSpecXmlReader.toDuration(value, "deadline")).orElse(defaultDeadline.orElse(Duration.ZERO));
            groups.add(new Bcp.Group(regions, deadline));
        }
        DeploymentSpecXmlReader.validateAndConsolidate(endpointsByZone, zoneEndpoints);
        return new Bcp(groups, defaultDeadline);
    }

    private Bcp complete(Bcp bcp, List<DeploymentSpec.Step> steps) {
        if (!bcp.groups().isEmpty()) {
            return bcp;
        }
        Bcp.Group group = new Bcp.Group(this.prodRegions(steps).stream().map(region -> new Bcp.RegionMember((RegionName)region, 1.0)).toList(), bcp.defaultDeadline().orElse(Duration.ZERO));
        return bcp.withGroups(List.of(group));
    }

    private Set<RegionName> prodRegions(List<DeploymentSpec.Step> steps) {
        return steps.stream().flatMap(s -> s.zones().stream()).filter(zone -> zone.environment().isProduction()).flatMap(z -> z.region().stream()).collect(Collectors.toSet());
    }

    static void validateAndConsolidate(Map<String, Map<RegionName, List<ZoneEndpoint>>> in, Map<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> out) {
        in.forEach((cluster, regions) -> {
            List wildcards = (List)regions.remove(null);
            ZoneEndpoint wildcardZoneEndpoint = null;
            ZoneEndpoint wildcardPrivateEndpoint = null;
            if (wildcards != null) {
                for (ZoneEndpoint endpoint : wildcards) {
                    if (endpoint.isPrivateEndpoint()) {
                        if (wildcardPrivateEndpoint != null) {
                            DeploymentSpecXmlReader.illegal("Multiple private endpoints (for all regions) declared for container id '" + cluster + "'");
                        }
                        wildcardPrivateEndpoint = endpoint;
                        continue;
                    }
                    if (wildcardZoneEndpoint != null) {
                        DeploymentSpecXmlReader.illegal("Multiple zone endpoints (for all regions) declared for container id '" + cluster + "'");
                    }
                    wildcardZoneEndpoint = endpoint;
                }
            }
            for (RegionName region : regions.keySet()) {
                ZoneEndpoint zoneEndpoint = null;
                ZoneEndpoint privateEndpoint = null;
                for (ZoneEndpoint endpoint : regions.getOrDefault(region, List.of())) {
                    if (endpoint.isPrivateEndpoint()) {
                        if (privateEndpoint != null) {
                            DeploymentSpecXmlReader.illegal("Multiple private endpoints declared for container id '" + cluster + "' in region '" + region + "'");
                        }
                        privateEndpoint = endpoint;
                        continue;
                    }
                    if (zoneEndpoint != null) {
                        DeploymentSpecXmlReader.illegal("Multiple zone endpoints (without regions) declared for container id '" + cluster + "' in region '" + region + "'");
                    }
                    zoneEndpoint = endpoint;
                }
                if (wildcardZoneEndpoint != null && zoneEndpoint != null) {
                    DeploymentSpecXmlReader.illegal("Zone endpoint for container id '" + cluster + "' declared both with region '" + region + "', and for all regions.");
                }
                if (wildcardPrivateEndpoint != null && privateEndpoint != null) {
                    DeploymentSpecXmlReader.illegal("Private endpoint for container id '" + cluster + "' declared both with region '" + region + "', and for all regions.");
                }
                if (zoneEndpoint == null) {
                    zoneEndpoint = wildcardZoneEndpoint;
                }
                if (privateEndpoint == null) {
                    privateEndpoint = wildcardPrivateEndpoint;
                }
                out.computeIfAbsent(ClusterSpec.Id.from((String)cluster), __ -> new LinkedHashMap()).put(ZoneId.from((Environment)Environment.prod, (RegionName)region), new ZoneEndpoint(zoneEndpoint == null || zoneEndpoint.isPublicEndpoint(), privateEndpoint != null, privateEndpoint != null ? privateEndpoint.allowedUrns() : List.of()));
            }
            out.computeIfAbsent(ClusterSpec.Id.from((String)cluster), __ -> new LinkedHashMap()).put(null, new ZoneEndpoint(wildcardZoneEndpoint == null || wildcardZoneEndpoint.isPublicEndpoint(), wildcardPrivateEndpoint != null, wildcardPrivateEndpoint != null ? wildcardPrivateEndpoint.allowedUrns() : List.of()));
        });
    }

    static Optional<String> getZoneEndpointType(Element endpoint, Endpoint.Level level) {
        String implied;
        Optional type = XML.attribute((String)"type", (Element)endpoint);
        if (type.isPresent() && !List.of("zone", "private", "global", "application").contains(type.get())) {
            DeploymentSpecXmlReader.illegal("Illegal endpoint type '" + (String)type.get() + "'");
        }
        switch (level) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case instance: {
                String string = "global";
                break;
            }
            case application: {
                String string = implied = "application";
            }
        }
        if (type.isEmpty() || ((String)type.get()).equals(implied)) {
            return Optional.empty();
        }
        if (level == Endpoint.Level.instance && (((String)type.get()).equals("zone") || ((String)type.get()).equals("private"))) {
            return type;
        }
        throw new IllegalArgumentException("Endpoints at " + level + " level cannot be of type '" + (String)type.get() + "'");
    }

    private void validateTagOrder(Element root) {
        List<String> tags = XML.getChildren((Element)root).stream().map(Element::getTagName).toList();
        for (int i = 0; i < tags.size(); ++i) {
            if (!tags.get(i).equals(blockChangeTag)) continue;
            String constraint = "<block-change> must be placed after <test> and <staging> and before <prod>";
            if (this.containsAfter(i, testTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (this.containsAfter(i, stagingTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (!this.containsBefore(i, prodTag, tags)) continue;
            DeploymentSpecXmlReader.illegal(constraint);
        }
    }

    private boolean containsAfter(int i, String item, List<String> items) {
        return items.subList(i + 1, items.size()).contains(item);
    }

    private boolean containsBefore(int i, String item, List<String> items) {
        return items.subList(0, i).contains(item);
    }

    private long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<Integer> optionalIntegerAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private static Optional<String> stringAttribute(String attributeName, Element tag) {
        return DeploymentSpecXmlReader.stringAttribute(attributeName, tag, true);
    }

    private static Optional<String> stringAttribute(String attributeName, Element tag, boolean ignoreBlanks) {
        String value = tag.getAttribute(attributeName);
        return Optional.of(value).filter(s -> tag.getAttributeNode(attributeName) != null && !ignoreBlanks || !s.isBlank());
    }

    private static String requireStringAttribute(String attributeName, Element tag) {
        return DeploymentSpecXmlReader.stringAttribute(attributeName, tag).orElseThrow(() -> new IllegalArgumentException("Missing required attribute '" + attributeName + "' in '" + tag.getTagName() + "'"));
    }

    private DeploymentSpec.DeclaredZone readDeclaredZone(Environment environment, Optional<AthenzService> athenzService, Optional<String> testerFlavor, Element regionTag) {
        return new DeploymentSpec.DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), athenzService, testerFlavor, this.readCloudAccounts(regionTag), this.readHostTTL(regionTag));
    }

    private Map<CloudName, CloudAccount> readCloudAccounts(Element tag) {
        return DeploymentSpecXmlReader.mostSpecificAttribute(tag, cloudAccountAttribute, false).map(value -> {
            HashMap<CloudName, CloudAccount> accounts = new HashMap<CloudName, CloudAccount>();
            for (String part : value.split(",")) {
                CloudAccount account = CloudAccount.from((String)part);
                accounts.merge(account.cloudName(), account, (o, n) -> {
                    throw DeploymentSpecXmlReader.illegal("both '" + o.account() + "' and '" + n.account() + "' are declared for cloud '" + o.cloudName() + "', in '" + value + "'");
                });
            }
            return accounts;
        }).orElse(Map.of());
    }

    private Optional<Duration> readHostTTL(Element tag) {
        return DeploymentSpecXmlReader.mostSpecificAttribute(tag, hostTTLAttribute).map(s -> DeploymentSpecXmlReader.toDuration(s, "empty host TTL"));
    }

    private List<DeploymentSpec.ChangeBlocker> readChangeBlockers(Element parent, Element globalBlockersParent) {
        ArrayList<DeploymentSpec.ChangeBlocker> changeBlockers = new ArrayList<DeploymentSpec.ChangeBlocker>();
        if (globalBlockersParent != parent) {
            for (Element tag : XML.getChildren((Element)globalBlockersParent, (String)blockChangeTag)) {
                changeBlockers.add(this.readChangeBlocker(tag));
            }
        }
        for (Element tag : XML.getChildren((Element)parent, (String)blockChangeTag)) {
            changeBlockers.add(this.readChangeBlocker(tag));
        }
        return Collections.unmodifiableList(changeBlockers);
    }

    private DeploymentSpec.ChangeBlocker readChangeBlocker(Element tag) {
        boolean blockVersions = this.trueOrMissing(tag.getAttribute("version"));
        boolean blockRevisions = this.trueOrMissing(tag.getAttribute("revision"));
        String daySpec = tag.getAttribute("days");
        String hourSpec = tag.getAttribute("hours");
        String zoneSpec = tag.getAttribute("time-zone");
        String dateStart = tag.getAttribute("from-date");
        String dateEnd = tag.getAttribute("to-date");
        return new DeploymentSpec.ChangeBlocker(blockRevisions, blockVersions, TimeWindow.from(daySpec, hourSpec, zoneSpec, dateStart, dateEnd));
    }

    private boolean trueOrMissing(String value) {
        return value == null || value.isEmpty() || value.equals("true");
    }

    private <T> T getWithFallback(Element parent, Element fallbackParent, String tagName, String attributeName, Function<String, T> mapper, T fallbackValue) {
        Element element = XML.getChild((Element)parent, (String)tagName);
        if (element == null) {
            element = XML.getChild((Element)fallbackParent, (String)tagName);
        }
        if (element == null) {
            return fallbackValue;
        }
        String attribute = element.getAttribute(attributeName);
        return attribute.isBlank() ? fallbackValue : mapper.apply(attribute);
    }

    private DeploymentSpec.UpgradePolicy readUpgradePolicy(String policy) {
        return switch (policy) {
            case "canary" -> DeploymentSpec.UpgradePolicy.canary;
            case "default" -> DeploymentSpec.UpgradePolicy.defaultPolicy;
            case "conservative" -> DeploymentSpec.UpgradePolicy.conservative;
            default -> throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of 'canary', 'default', 'conservative'");
        };
    }

    private DeploymentSpec.RevisionChange readRevisionChange(String revision) {
        return switch (revision) {
            case "when-clear" -> DeploymentSpec.RevisionChange.whenClear;
            case "when-failing" -> DeploymentSpec.RevisionChange.whenFailing;
            case "always" -> DeploymentSpec.RevisionChange.always;
            default -> throw new IllegalArgumentException("Illegal upgrade revision change policy '" + revision + "': Must be one of 'always', 'when-failing', 'when-clear'");
        };
    }

    private DeploymentSpec.RevisionTarget readRevisionTarget(String revision) {
        return switch (revision) {
            case "next" -> DeploymentSpec.RevisionTarget.next;
            case "latest" -> DeploymentSpec.RevisionTarget.latest;
            default -> throw new IllegalArgumentException("Illegal upgrade revision target '" + revision + "': Must be one of 'next', 'latest'");
        };
    }

    private DeploymentSpec.UpgradeRollout readUpgradeRollout(String rollout) {
        return switch (rollout) {
            case "separate" -> DeploymentSpec.UpgradeRollout.separate;
            case "leading" -> DeploymentSpec.UpgradeRollout.leading;
            case "simultaneous" -> DeploymentSpec.UpgradeRollout.simultaneous;
            default -> throw new IllegalArgumentException("Illegal upgrade rollout '" + rollout + "': Must be one of 'separate', 'leading', 'simultaneous'");
        };
    }

    private void deprecate(Element element, List<String> attributes, int majorVersion, String message) {
        this.deprecatedElements.add(new DeploymentSpec.DeprecatedElement(majorVersion, element.getTagName(), attributes, message));
    }

    private static boolean isEmptySpec(Element root) {
        if (!XML.getChildren((Element)root).isEmpty()) {
            return false;
        }
        return root.getAttributes().getLength() == 0 || root.getAttributes().getLength() == 1 && root.hasAttribute("version");
    }

    private static Optional<String> mostSpecificAttribute(Element tag, String attributeName, boolean ignoreBlanks) {
        return Stream.iterate(tag, Objects::nonNull, Node::getParentNode).filter(Element.class::isInstance).map(Element.class::cast).flatMap(element -> DeploymentSpecXmlReader.stringAttribute(attributeName, element, ignoreBlanks).stream()).findFirst();
    }

    private static Optional<String> mostSpecificAttribute(Element tag, String attributeName) {
        return DeploymentSpecXmlReader.mostSpecificAttribute(tag, attributeName, true);
    }

    private static Duration toDuration(String durationSpec, String sourceDescription) {
        try {
            if (durationSpec == null || durationSpec.isBlank()) {
                return Duration.ZERO;
            }
            durationSpec = durationSpec.trim().toLowerCase();
            int magnitude = DeploymentSpecXmlReader.toMagnitude(durationSpec);
            return switch (durationSpec.substring(durationSpec.length() - 1)) {
                case "m" -> Duration.ofMinutes(magnitude);
                case "h" -> Duration.ofHours(magnitude);
                case "d" -> Duration.ofDays(magnitude);
                default -> throw new IllegalArgumentException("Must end by 'm', 'h' or 'd'");
            };
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal " + sourceDescription + " '" + durationSpec + "'", e);
        }
    }

    private static int toMagnitude(String durationSpec) {
        try {
            return Integer.parseInt(durationSpec.substring(0, durationSpec.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Must be an integer followed by 'm', 'h' or 'd'");
        }
    }

    private static OptionalDouble toDouble(String value, String sourceDescription) {
        try {
            if (value == null || value.isBlank()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal " + sourceDescription + " '" + value + "': Must be a number between 0.0 and 1.0");
        }
    }

    private static IllegalArgumentException illegal(String message) {
        throw new IllegalArgumentException(message);
    }
}

