/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.google.common.collect.ImmutableMap;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SuperModel {
    private final Map<ApplicationId, ApplicationInfo> models;

    public SuperModel() {
        this.models = Collections.emptyMap();
    }

    public SuperModel(Map<ApplicationId, ApplicationInfo> models) {
        this.models = models;
    }

    public Map<TenantName, Set<ApplicationInfo>> getModelsPerTenant() {
        LinkedHashMap<TenantName, Set<ApplicationInfo>> newModels = new LinkedHashMap<TenantName, Set<ApplicationInfo>>();
        this.models.forEach((key, value) -> {
            if (!newModels.containsKey(key.tenant())) {
                newModels.put(key.tenant(), new LinkedHashSet());
            }
            ((Set)newModels.get(key.tenant())).add(value);
        });
        return newModels;
    }

    public Map<ApplicationId, ApplicationInfo> getModels() {
        return ImmutableMap.copyOf(this.models);
    }

    public List<ApplicationInfo> getAllApplicationInfos() {
        return new ArrayList<ApplicationInfo>(this.models.values());
    }

    public Optional<ApplicationInfo> getApplicationInfo(ApplicationId applicationId) {
        ApplicationInfo applicationInfo = this.models.get(applicationId);
        return applicationInfo == null ? Optional.empty() : Optional.of(applicationInfo);
    }

    public SuperModel cloneAndSetApplication(ApplicationInfo application) {
        Map<ApplicationId, ApplicationInfo> newModels = SuperModel.cloneModels(this.models);
        newModels.put(application.getApplicationId(), application);
        return new SuperModel(newModels);
    }

    public SuperModel cloneAndRemoveApplication(ApplicationId applicationId) {
        Map<ApplicationId, ApplicationInfo> newModels = SuperModel.cloneModels(this.models);
        newModels.remove(applicationId);
        return new SuperModel(newModels);
    }

    private static Map<ApplicationId, ApplicationInfo> cloneModels(Map<ApplicationId, ApplicationInfo> models) {
        return new LinkedHashMap<ApplicationId, ApplicationInfo>(models);
    }
}

