/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(Optional.empty(), UpgradePolicy.defaultPolicy, Optional.empty(), Collections.emptyList(), Collections.emptyList(), "<deployment version='1.0'/>", Optional.empty(), Optional.empty(), Notifications.none());
    private final Optional<String> globalServiceId;
    private final UpgradePolicy upgradePolicy;
    private final Optional<Integer> majorVersion;
    private final List<ChangeBlocker> changeBlockers;
    private final List<Step> steps;
    private final String xmlForm;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final Notifications notifications;

    public DeploymentSpec(Optional<String> globalServiceId, UpgradePolicy upgradePolicy, Optional<Integer> majorVersion, List<ChangeBlocker> changeBlockers, List<Step> steps, String xmlForm, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, Notifications notifications) {
        this.validateTotalDelay(steps);
        this.globalServiceId = globalServiceId;
        this.upgradePolicy = upgradePolicy;
        this.majorVersion = majorVersion;
        this.changeBlockers = changeBlockers;
        this.steps = ImmutableList.copyOf(DeploymentSpec.completeSteps(new ArrayList<Step>(steps)));
        this.xmlForm = xmlForm;
        this.athenzDomain = athenzDomain;
        this.athenzService = athenzService;
        this.notifications = notifications;
        this.validateZones(this.steps);
        this.validateAthenz();
    }

    private void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().filter(step -> step instanceof Delay).mapToLong(delay -> ((Delay)delay).duration().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(24L).getSeconds()) {
            throw new IllegalArgumentException("The total delay specified is " + Duration.ofSeconds(totalDelaySeconds) + " but max 24 hours is allowed");
        }
    }

    private void validateZones(List<Step> steps) {
        HashSet<DeclaredZone> zones = new HashSet<DeclaredZone>();
        for (Step step : steps) {
            for (DeclaredZone zone : step.zones()) {
                this.ensureUnique(zone, zones);
            }
        }
    }

    private void validateAthenz() {
        block3: {
            block2: {
                if (this.athenzDomain.isPresent()) break block2;
                for (DeclaredZone zone : this.zones()) {
                    if (!zone.athenzService().isPresent()) continue;
                    throw new IllegalArgumentException("Athenz service configured for zone: " + zone + ", but Athenz domain is not configured");
                }
                break block3;
            }
            if (this.athenzService.isPresent()) break block3;
            for (DeclaredZone zone : this.zones()) {
                if (zone.athenzService().isPresent()) continue;
                throw new IllegalArgumentException("Athenz domain is configured, but Athenz service not configured for zone: " + zone);
            }
        }
    }

    private void ensureUnique(DeclaredZone zone, Set<DeclaredZone> zones) {
        if (!zones.add(zone)) {
            throw new IllegalArgumentException(zone + " is listed twice in deployment.xml");
        }
    }

    private static List<Step> completeSteps(List<Step> steps) {
        DeclaredZone stagingStep;
        DeclaredZone testStep;
        if (steps.stream().anyMatch(step -> step.deploysTo(Environment.prod)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.staging))) {
            steps.add(new DeclaredZone(Environment.staging));
        }
        if (steps.stream().anyMatch(step -> step.deploysTo(Environment.staging)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.test))) {
            steps.add(new DeclaredZone(Environment.test));
        }
        if ((testStep = DeploymentSpec.remove(Environment.test, steps)) != null) {
            steps.add(0, testStep);
        }
        if ((stagingStep = DeploymentSpec.remove(Environment.staging, steps)) != null) {
            steps.add(1, stagingStep);
        }
        return steps;
    }

    private static DeclaredZone remove(Environment environment, List<Step> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            if (!steps.get(i).deploysTo(environment)) continue;
            return (DeclaredZone)steps.remove(i);
        }
        return null;
    }

    public Optional<String> globalServiceId() {
        return this.globalServiceId;
    }

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public Optional<Integer> majorVersion() {
        return this.majorVersion;
    }

    public boolean canUpgradeAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksVersions()).noneMatch(block -> block.window().includes(instant));
    }

    public boolean canChangeRevisionAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksRevisions()).noneMatch(block -> block.window().includes(instant));
    }

    public List<ChangeBlocker> changeBlocker() {
        return this.changeBlockers;
    }

    public List<Step> steps() {
        return this.steps;
    }

    public List<DeclaredZone> zones() {
        return this.steps.stream().flatMap(step -> step.zones().stream()).collect(Collectors.toList());
    }

    public Notifications notifications() {
        return this.notifications;
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public boolean includes(Environment environment, Optional<RegionName> region) {
        for (Step step : this.steps) {
            if (!step.deploysTo(environment, region)) continue;
            return true;
        }
        return false;
    }

    public static DeploymentSpec fromXml(Reader reader) {
        return new DeploymentSpecXmlReader().read(reader);
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        return DeploymentSpec.fromXml(xmlForm, true);
    }

    public static DeploymentSpec fromXml(String xmlForm, boolean validate) {
        return new DeploymentSpecXmlReader(validate).read(xmlForm);
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService(Environment environment, RegionName region) {
        AthenzService athenzService = this.zones().stream().filter(zone -> zone.deploysTo(environment, Optional.of(region))).findFirst().flatMap(DeclaredZone::athenzService).orElse(this.athenzService.orElse(null));
        return Optional.ofNullable(athenzService);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpec that = (DeploymentSpec)o;
        return this.globalServiceId.equals(that.globalServiceId) && this.upgradePolicy == that.upgradePolicy && this.majorVersion.equals(that.majorVersion) && this.changeBlockers.equals(that.changeBlockers) && this.steps.equals(that.steps) && this.xmlForm.equals(that.xmlForm) && this.athenzDomain.equals(that.athenzDomain) && this.athenzService.equals(that.athenzService) && this.notifications.equals(that.notifications);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.globalServiceId, this.upgradePolicy, this.majorVersion, this.changeBlockers, this.steps, this.xmlForm, this.athenzDomain, this.athenzService, this.notifications});
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: DeploymentSpec [file] [environment] [region]?Returns 0 if the specified zone matches the deployment spec, 1 otherwise");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(args[0]));){
            Optional<RegionName> region;
            DeploymentSpec spec = DeploymentSpec.fromXml(reader);
            Environment environment = Environment.from((String)args[1]);
            Optional<RegionName> optional = region = args.length == 3 ? Optional.of(RegionName.from((String)args[2])) : Optional.empty();
            if (spec.includes(environment, region)) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception checking deployment spec: " + DeploymentSpec.toMessageString(e));
            System.exit(1);
        }
    }

    public static class ChangeBlocker {
        private final boolean revision;
        private final boolean version;
        private final TimeWindow window;

        public ChangeBlocker(boolean revision, boolean version, TimeWindow window) {
            this.revision = revision;
            this.version = version;
            this.window = window;
        }

        public boolean blocksRevisions() {
            return this.revision;
        }

        public boolean blocksVersions() {
            return this.version;
        }

        public TimeWindow window() {
            return this.window;
        }
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static class ParallelZones
    extends Step {
        private final List<DeclaredZone> zones;

        public ParallelZones(List<DeclaredZone> zones) {
            this.zones = ImmutableList.copyOf(zones);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.zones;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return this.zones.stream().anyMatch(zone -> zone.deploysTo(environment, region));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelZones)) {
                return false;
            }
            ParallelZones that = (ParallelZones)o;
            return Objects.equals(this.zones, that.zones);
        }

        public int hashCode() {
            return Objects.hash(this.zones);
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private final Optional<RegionName> region;
        private final boolean active;
        private final Optional<AthenzService> athenzService;
        private final Optional<String> testerFlavor;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), false);
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active) {
            this(environment, region, active, Optional.empty(), Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService) {
            this(environment, region, active, athenzService, Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService, Optional<String> testerFlavor) {
            if (environment != Environment.prod && region.isPresent()) {
                throw new IllegalArgumentException("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && !region.isPresent()) {
                throw new IllegalArgumentException("Prod environments must be specified with a region");
            }
            this.environment = environment;
            this.region = region;
            this.active = active;
            this.athenzService = athenzService;
            this.testerFlavor = testerFlavor;
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public boolean active() {
            return this.active;
        }

        public Optional<String> testerFlavor() {
            return this.testerFlavor;
        }

        public Optional<AthenzService> athenzService() {
            return this.athenzService;
        }

        @Override
        public List<DeclaredZone> zones() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || region.equals(this.region);
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return this.environment + (String)(this.region.isPresent() ? "." + this.region.get() : "");
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        public Duration duration() {
            return this.duration;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return false;
        }
    }

    public static abstract class Step {
        public final boolean deploysTo(Environment environment) {
            return this.deploysTo(environment, Optional.empty());
        }

        public abstract boolean deploysTo(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return Collections.emptyList();
        }
    }
}

