/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ModelContext {
    public ApplicationPackage applicationPackage();

    public Optional<Model> previousModel();

    public Optional<ApplicationPackage> permanentApplicationPackage();

    public Optional<HostProvisioner> hostProvisioner();

    public Provisioned provisioned();

    public DeployLogger deployLogger();

    public ConfigDefinitionRepo configDefinitionRepo();

    public FileRegistry getFileRegistry();

    default public Optional<? extends Reindexing> reindexing() {
        return Optional.empty();
    }

    public Properties properties();

    default public Optional<File> appDir() {
        return Optional.empty();
    }

    default public Optional<DockerImage> wantedDockerImageRepo() {
        return Optional.empty();
    }

    public Version modelVespaVersion();

    public Version wantedNodeVespaVersion();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ModelFeatureFlag {
        public String[] owners();

        public String comment() default "";
    }

    public static interface Properties {
        public FeatureFlags featureFlags();

        public boolean multitenant();

        public ApplicationId applicationId();

        public List<ConfigServerSpec> configServerSpecs();

        public HostName loadBalancerName();

        public URI ztsUrl();

        public String athenzDnsSuffix();

        public boolean hostedVespa();

        public Zone zone();

        public Set<ContainerEndpoint> endpoints();

        public boolean isBootstrap();

        public boolean isFirstTimeDeployment();

        default public boolean useDedicatedNodeForLogserver() {
            return true;
        }

        default public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return Optional.empty();
        }

        public double defaultTermwiseLimit();

        default public int defaultNumResponseThreads() {
            return 2;
        }

        default public double threadPoolSizeFactor() {
            return 2.0;
        }

        default public double queueSizeFactor() {
            return 40.0;
        }

        public String jvmGCOptions();

        public String feedSequencerType();

        public String responseSequencerType();

        public boolean skipCommunicationManagerThread();

        public boolean skipMbusRequestThread();

        public boolean skipMbusReplyThread();

        public boolean useAsyncMessageHandlingOnSchedule();

        public int contentNodeBucketDBStripeBits();

        public int mergeChunkSize();

        public double feedConcurrency();

        public boolean useThreePhaseUpdates();

        public boolean useDirectStorageApiRpc();

        public boolean useFastValueTensorImplementation();

        default public String proxyProtocol() {
            return "https+proxy-protocol";
        }

        default public Optional<AthenzDomain> athenzDomain() {
            return Optional.empty();
        }

        public Optional<ApplicationRoles> applicationRoles();

        default public Duration jdiscHealthCheckProxyClientTimeout() {
            return Duration.ofMillis(100L);
        }

        default public double feedCoreThreadPoolSizeFactor() {
            return 4.0;
        }

        default public Quota quota() {
            return Quota.unlimited();
        }

        default public boolean useNewRestapiHandler() {
            return true;
        }

        default public boolean useAccessControlTlsHandshakeClientAuth() {
            return false;
        }

        default public double jettyThreadpoolSizeFactor() {
            return 1.0;
        }
    }

    public static interface FeatureFlags {
        @ModelFeatureFlag(owners={"bjorncs", "jonmv"})
        default public boolean enableAutomaticReindexing() {
            return false;
        }
    }
}

