/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api.xml;

import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentSpecXmlReader {
    private static final String instanceTag = "instance";
    private static final String majorVersionTag = "major-version";
    private static final String testTag = "test";
    private static final String stagingTag = "staging";
    private static final String upgradeTag = "upgrade";
    private static final String blockChangeTag = "block-change";
    private static final String prodTag = "prod";
    private static final String regionTag = "region";
    private static final String delayTag = "delay";
    private static final String parallelTag = "parallel";
    private static final String stepsTag = "steps";
    private static final String endpointsTag = "endpoints";
    private static final String endpointTag = "endpoint";
    private static final String notificationsTag = "notifications";
    private static final String idAttribute = "id";
    private static final String athenzServiceAttribute = "athenz-service";
    private static final String athenzDomainAttribute = "athenz-domain";
    private static final String testerFlavorAttribute = "tester-flavor";
    private final boolean validate;

    public DeploymentSpecXmlReader() {
        this(true);
    }

    public DeploymentSpecXmlReader(boolean validate) {
        this.validate = validate;
    }

    public DeploymentSpec read(Reader reader) {
        try {
            return this.read(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public DeploymentSpec read(String xmlForm) {
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        if (!this.containsTag(instanceTag, root)) {
            steps.addAll(this.readInstanceContent("default", root, new MutableOptional<String>(), root));
        } else {
            if (XML.getChildren((Element)root).stream().anyMatch(child -> child.getTagName().equals(prodTag))) {
                throw new IllegalArgumentException("A deployment spec cannot have both a <prod> tag and an <instance> tag under the root: Wrap the prod tags inside the appropriate instance");
            }
            for (Element topLevelTag : XML.getChildren((Element)root)) {
                if (topLevelTag.getTagName().equals(instanceTag)) {
                    steps.addAll(this.readInstanceContent(topLevelTag.getAttribute(idAttribute), topLevelTag, new MutableOptional<String>(), root));
                    continue;
                }
                steps.addAll(this.readNonInstanceSteps(topLevelTag, new MutableOptional<String>(), root));
            }
        }
        return new DeploymentSpec(steps, this.optionalIntegerAttribute(majorVersionTag, root), this.stringAttribute(athenzDomainAttribute, root).map(AthenzDomain::from), this.stringAttribute(athenzServiceAttribute, root).map(AthenzService::from), xmlForm);
    }

    private List<DeploymentInstanceSpec> readInstanceContent(String instanceNameString, Element instanceTag, MutableOptional<String> globalServiceId, Element parentTag) {
        if (this.validate) {
            this.validateTagOrder(instanceTag);
        }
        DeploymentSpec.UpgradePolicy upgradePolicy = this.readUpgradePolicy(instanceTag, parentTag);
        List<DeploymentSpec.ChangeBlocker> changeBlockers = this.readChangeBlockers(instanceTag, parentTag);
        Optional<AthenzDomain> athenzDomain = this.stringAttribute(athenzDomainAttribute, instanceTag).or(() -> this.stringAttribute(athenzDomainAttribute, parentTag)).map(AthenzDomain::from);
        Optional<AthenzService> athenzService = this.stringAttribute(athenzServiceAttribute, instanceTag).or(() -> this.stringAttribute(athenzServiceAttribute, parentTag)).map(AthenzService::from);
        Notifications notifications = this.readNotifications(instanceTag, parentTag);
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        for (Element instanceChild : XML.getChildren((Element)instanceTag)) {
            steps.addAll(this.readNonInstanceSteps(instanceChild, globalServiceId, instanceChild));
        }
        List<Endpoint> endpoints = this.readEndpoints(instanceTag);
        return Arrays.stream(instanceNameString.split(",")).map(name -> name.trim()).map(name -> new DeploymentInstanceSpec(InstanceName.from((String)name), steps, upgradePolicy, changeBlockers, globalServiceId.asOptional(), athenzDomain, athenzService, notifications, endpoints)).collect(Collectors.toList());
    }

    private List<DeploymentSpec.Step> readSteps(Element stepTag, MutableOptional<String> globalServiceId, Element parentTag) {
        if (stepTag.getTagName().equals(instanceTag)) {
            return new ArrayList<DeploymentSpec.Step>(this.readInstanceContent(stepTag.getAttribute(idAttribute), stepTag, globalServiceId, parentTag));
        }
        return this.readNonInstanceSteps(stepTag, globalServiceId, parentTag);
    }

    private List<DeploymentSpec.Step> readNonInstanceSteps(Element stepTag, MutableOptional<String> globalServiceId, Element parentTag) {
        Optional<AthenzService> athenzService = this.stringAttribute(athenzServiceAttribute, stepTag).or(() -> this.stringAttribute(athenzServiceAttribute, parentTag)).map(AthenzService::from);
        Optional<String> testerFlavor = this.stringAttribute(testerFlavorAttribute, stepTag).or(() -> this.stringAttribute(testerFlavorAttribute, parentTag));
        if (prodTag.equals(stepTag.getTagName())) {
            globalServiceId.set(this.readGlobalServiceId(stepTag));
        } else if (this.readGlobalServiceId(stepTag).isPresent()) {
            throw new IllegalArgumentException("Attribute 'global-service-id' is only valid on 'prod' tag.");
        }
        switch (stepTag.getTagName()) {
            case "test": {
                if (Stream.iterate(stepTag, Objects::nonNull, Node::getParentNode).anyMatch(node -> prodTag.equals(node.getNodeName()))) {
                    return List.of(new DeploymentSpec.DeclaredTest(RegionName.from((String)XML.getValue((Element)stepTag).trim())));
                }
            }
            case "staging": {
                return List.of(new DeploymentSpec.DeclaredZone(Environment.from((String)stepTag.getTagName()), Optional.empty(), false, athenzService, testerFlavor));
            }
            case "prod": {
                return XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readNonInstanceSteps((Element)child, globalServiceId, stepTag).stream()).collect(Collectors.toList());
            }
            case "delay": {
                return List.of(new DeploymentSpec.Delay(Duration.ofSeconds(this.longAttribute("hours", stepTag) * 60L * 60L + this.longAttribute("minutes", stepTag) * 60L + this.longAttribute("seconds", stepTag))));
            }
            case "parallel": {
                return List.of(new DeploymentSpec.ParallelSteps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, globalServiceId, parentTag).stream()).collect(Collectors.toList())));
            }
            case "steps": {
                return List.of(new DeploymentSpec.Steps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, globalServiceId, parentTag).stream()).collect(Collectors.toList())));
            }
            case "region": {
                return List.of(this.readDeclaredZone(Environment.prod, athenzService, testerFlavor, stepTag));
            }
        }
        return List.of();
    }

    private boolean containsTag(String childTagName, Element parent) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!child.getTagName().equals(childTagName) && !this.containsTag(childTagName, child)) continue;
            return true;
        }
        return false;
    }

    private Notifications readNotifications(Element parent, Element fallbackParent) {
        Element notificationsElement = XML.getChild((Element)parent, (String)notificationsTag);
        if (notificationsElement == null) {
            notificationsElement = XML.getChild((Element)fallbackParent, (String)notificationsTag);
        }
        if (notificationsElement == null) {
            return Notifications.none();
        }
        Notifications.When defaultWhen = this.stringAttribute("when", notificationsElement).map(Notifications.When::fromValue).orElse(Notifications.When.failingCommit);
        HashMap<Notifications.When, List<String>> emailAddresses = new HashMap<Notifications.When, List<String>>();
        HashMap<Notifications.When, List<Notifications.Role>> emailRoles = new HashMap<Notifications.When, List<Notifications.Role>>();
        for (Notifications.When when : Notifications.When.values()) {
            emailAddresses.put(when, new ArrayList());
            emailRoles.put(when, new ArrayList());
        }
        for (Element emailElement : XML.getChildren((Element)notificationsElement, (String)"email")) {
            Optional<String> addressAttribute = this.stringAttribute("address", emailElement);
            Optional<Notifications.Role> roleAttribute = this.stringAttribute("role", emailElement).map(Notifications.Role::fromValue);
            Notifications.When when = this.stringAttribute("when", emailElement).map(Notifications.When::fromValue).orElse(defaultWhen);
            if (addressAttribute.isPresent() == roleAttribute.isPresent()) {
                throw new IllegalArgumentException("Exactly one of 'role' and 'address' must be present in 'email' elements.");
            }
            addressAttribute.ifPresent(address -> ((List)emailAddresses.get((Object)when)).add(address));
            roleAttribute.ifPresent(role -> ((List)emailRoles.get((Object)when)).add(role));
        }
        return Notifications.of(emailAddresses, emailRoles);
    }

    private List<Endpoint> readEndpoints(Element parent) {
        Element endpointsElement = XML.getChild((Element)parent, (String)endpointsTag);
        if (endpointsElement == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Endpoint> endpoints = new LinkedHashMap<String, Endpoint>();
        for (Element endpointElement : XML.getChildren((Element)endpointsElement, (String)endpointTag)) {
            Optional<String> rotationId = this.stringAttribute(idAttribute, endpointElement);
            Optional<String> containerId = this.stringAttribute("container-id", endpointElement);
            HashSet<String> regions = new HashSet<String>();
            if (containerId.isEmpty()) {
                throw new IllegalArgumentException("Missing 'container-id' from 'endpoint' tag.");
            }
            for (Element regionElement : XML.getChildren((Element)endpointElement, (String)regionTag)) {
                String region = regionElement.getTextContent();
                if (region == null || region.isEmpty() || region.isBlank()) {
                    throw new IllegalArgumentException("Empty 'region' element in 'endpoint' tag.");
                }
                if (regions.contains(region)) {
                    throw new IllegalArgumentException("Duplicate 'region' element in 'endpoint' tag: " + region);
                }
                regions.add(region);
            }
            Endpoint endpoint = new Endpoint(rotationId, containerId.get(), regions);
            if (endpoints.containsKey(endpoint.endpointId())) {
                throw new IllegalArgumentException("Duplicate attribute 'id' on 'endpoint': " + endpoint.endpointId());
            }
            endpoints.put(endpoint.endpointId(), endpoint);
        }
        return List.copyOf(endpoints.values());
    }

    private void validateTagOrder(Element root) {
        List<String> tags = XML.getChildren((Element)root).stream().map(Element::getTagName).collect(Collectors.toList());
        for (int i = 0; i < tags.size(); ++i) {
            if (!((String)tags.get(i)).equals(blockChangeTag)) continue;
            String constraint = "<block-change> must be placed after <test> and <staging> and before <prod>";
            if (this.containsAfter(i, testTag, tags)) {
                throw new IllegalArgumentException(constraint);
            }
            if (this.containsAfter(i, stagingTag, tags)) {
                throw new IllegalArgumentException(constraint);
            }
            if (!this.containsBefore(i, prodTag, tags)) continue;
            throw new IllegalArgumentException(constraint);
        }
    }

    private boolean containsAfter(int i, String item, List<String> items) {
        return items.subList(i + 1, items.size()).contains(item);
    }

    private boolean containsBefore(int i, String item, List<String> items) {
        return items.subList(0, i).contains(item);
    }

    private long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<Integer> optionalIntegerAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<String> stringAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        return Optional.ofNullable(value).filter(s -> !s.equals(""));
    }

    private DeploymentSpec.DeclaredZone readDeclaredZone(Environment environment, Optional<AthenzService> athenzService, Optional<String> testerFlavor, Element regionTag) {
        return new DeploymentSpec.DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), this.readActive(regionTag), athenzService, testerFlavor);
    }

    private Optional<String> readGlobalServiceId(Element environmentTag) {
        String globalServiceId = environmentTag.getAttribute("global-service-id");
        if (globalServiceId == null || globalServiceId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(globalServiceId);
    }

    private List<DeploymentSpec.ChangeBlocker> readChangeBlockers(Element parent, Element globalBlockersParent) {
        ArrayList<DeploymentSpec.ChangeBlocker> changeBlockers = new ArrayList<DeploymentSpec.ChangeBlocker>();
        if (globalBlockersParent != parent) {
            for (Element tag : XML.getChildren((Element)globalBlockersParent, (String)blockChangeTag)) {
                changeBlockers.add(this.readChangeBlocker(tag));
            }
        }
        for (Element tag : XML.getChildren((Element)parent, (String)blockChangeTag)) {
            changeBlockers.add(this.readChangeBlocker(tag));
        }
        return Collections.unmodifiableList(changeBlockers);
    }

    private DeploymentSpec.ChangeBlocker readChangeBlocker(Element tag) {
        boolean blockVersions = this.trueOrMissing(tag.getAttribute("version"));
        boolean blockRevisions = this.trueOrMissing(tag.getAttribute("revision"));
        String daySpec = tag.getAttribute("days");
        String hourSpec = tag.getAttribute("hours");
        String zoneSpec = tag.getAttribute("time-zone");
        if (zoneSpec.isEmpty()) {
            zoneSpec = "UTC";
        }
        return new DeploymentSpec.ChangeBlocker(blockRevisions, blockVersions, TimeWindow.from(daySpec, hourSpec, zoneSpec));
    }

    private boolean trueOrMissing(String value) {
        return value == null || value.isEmpty() || value.equals("true");
    }

    private DeploymentSpec.UpgradePolicy readUpgradePolicy(Element parent, Element fallbackParent) {
        String policy;
        Element upgradeElement = XML.getChild((Element)parent, (String)upgradeTag);
        if (upgradeElement == null) {
            upgradeElement = XML.getChild((Element)fallbackParent, (String)upgradeTag);
        }
        if (upgradeElement == null) {
            return DeploymentSpec.UpgradePolicy.defaultPolicy;
        }
        switch (policy = upgradeElement.getAttribute("policy")) {
            case "canary": {
                return DeploymentSpec.UpgradePolicy.canary;
            }
            case "default": {
                return DeploymentSpec.UpgradePolicy.defaultPolicy;
            }
            case "conservative": {
                return DeploymentSpec.UpgradePolicy.conservative;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of " + Arrays.toString((Object[])DeploymentSpec.UpgradePolicy.values()));
    }

    private boolean readActive(Element regionTag) {
        String activeValue = regionTag.getAttribute("active");
        if ("true".equals(activeValue)) {
            return true;
        }
        if ("false".equals(activeValue)) {
            return false;
        }
        throw new IllegalArgumentException("Region tags must have an 'active' attribute set to 'true' or 'false' to control whether the region should receive production traffic");
    }

    private static class MutableOptional<T> {
        private Optional<T> value = Optional.empty();

        private MutableOptional() {
        }

        public void set(Optional<T> value) {
            this.value = value;
        }

        public Optional<T> asOptional() {
            return this.value;
        }
    }
}

