/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.google.common.collect.ImmutableMap;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SuperModel {
    private final Map<ApplicationId, ApplicationInfo> models;

    public SuperModel() {
        this.models = Collections.emptyMap();
    }

    public SuperModel(Map<TenantName, Map<ApplicationId, ApplicationInfo>> models) {
        this.models = new LinkedHashMap<ApplicationId, ApplicationInfo>();
        models.values().forEach(entry -> entry.forEach(this.models::put));
    }

    public SuperModel(Map<ApplicationId, ApplicationInfo> models, boolean ignored) {
        this.models = models;
    }

    public Map<TenantName, Map<ApplicationId, ApplicationInfo>> getAllModels() {
        LinkedHashMap<TenantName, Map<ApplicationId, ApplicationInfo>> newModels = new LinkedHashMap<TenantName, Map<ApplicationId, ApplicationInfo>>();
        this.models.forEach((key, value) -> {
            if (!newModels.containsKey(key.tenant())) {
                newModels.put(key.tenant(), new LinkedHashMap());
            }
            ((Map)newModels.get(key.tenant())).put(key, value);
        });
        return newModels;
    }

    public Map<TenantName, Set<ApplicationInfo>> getModelsPerTenant() {
        LinkedHashMap<TenantName, Set<ApplicationInfo>> newModels = new LinkedHashMap<TenantName, Set<ApplicationInfo>>();
        this.models.forEach((key, value) -> {
            if (!newModels.containsKey(key.tenant())) {
                newModels.put(key.tenant(), new LinkedHashSet());
            }
            ((Set)newModels.get(key.tenant())).add(value);
        });
        return newModels;
    }

    public Map<ApplicationId, ApplicationInfo> getModels() {
        return ImmutableMap.copyOf(this.models);
    }

    public List<ApplicationInfo> getAllApplicationInfos() {
        return new ArrayList<ApplicationInfo>(this.models.values());
    }

    public Optional<ApplicationInfo> getApplicationInfo(ApplicationId applicationId) {
        ApplicationInfo applicationInfo = this.models.get(applicationId);
        return applicationInfo == null ? Optional.empty() : Optional.of(applicationInfo);
    }

    public SuperModel cloneAndSetApplication(ApplicationInfo application) {
        Map<ApplicationId, ApplicationInfo> newModels = SuperModel.cloneModels(this.models);
        newModels.put(application.getApplicationId(), application);
        return new SuperModel(newModels, false);
    }

    public SuperModel cloneAndRemoveApplication(ApplicationId applicationId) {
        Map<ApplicationId, ApplicationInfo> newModels = SuperModel.cloneModels(this.models);
        newModels.remove(applicationId);
        return new SuperModel(newModels, false);
    }

    private static Map<ApplicationId, ApplicationInfo> cloneModels(Map<ApplicationId, ApplicationInfo> models) {
        return new LinkedHashMap<ApplicationId, ApplicationInfo>(models);
    }
}

