/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.config.model.api.PortInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ServiceInfo {
    private final String serviceName;
    private final String serviceType;
    private final Collection<PortInfo> ports;
    private final Map<String, String> properties;
    private final String configId;
    private final String hostName;

    public ServiceInfo(String serviceName, String serviceType, Collection<PortInfo> ports, Map<String, String> properties, String configId, String hostName) {
        Objects.requireNonNull(configId);
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.ports = ports;
        this.properties = properties;
        this.configId = configId;
        this.hostName = hostName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public Collection<PortInfo> getPorts() {
        return this.ports;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (!this.serviceName.equals(that.serviceName)) {
            return false;
        }
        if (!this.serviceType.equals(that.serviceType)) {
            return false;
        }
        if (!this.configId.equals(that.configId)) {
            return false;
        }
        return this.hostName.equals(that.hostName);
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.serviceType.hashCode();
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + this.configId.hashCode();
        result = 31 * result + this.hostName.hashCode();
        return result;
    }
}

